/*
 * Decompiled with CFR 0.152.
 */
package com.synerset.unitility.unitsystem;

import com.synerset.unitility.unitsystem.PhysicalQuantity;
import com.synerset.unitility.unitsystem.Unit;
import com.synerset.unitility.unitsystem.exceptions.UnitSystemArgumentException;
import com.synerset.unitility.unitsystem.util.ValueFormatter;

public interface CalculableQuantity<U extends Unit, Q extends CalculableQuantity<U, Q>>
extends PhysicalQuantity<U> {
    public Q withValue(double var1);

    default public Q plus(double value) {
        double newValue = this.getValue() + value;
        return (Q)this.withValue(newValue);
    }

    default public Q minus(double value) {
        double newValue = this.getValue() - value;
        return (Q)this.withValue(newValue);
    }

    default public Q minusFromValue(double value) {
        double newValue = value - this.getValue();
        return (Q)this.withValue(newValue);
    }

    default public Q multiply(double value) {
        double newValue = this.getValue() * value;
        return (Q)this.withValue(newValue);
    }

    default public Q times(double value) {
        return this.multiply(value);
    }

    default public Q divide(double value) {
        if (value == 0.0) {
            throw new UnitSystemArgumentException("Division by zero is not allowed. Please provide a non-zero divider value.");
        }
        double newValue = this.getValue() / value;
        return (Q)this.withValue(newValue);
    }

    default public Q div(double value) {
        return this.divide(value);
    }

    default public Q abs() {
        return (Q)this.withValue(Math.abs(this.getValue()));
    }

    default public Q power(double exponent) {
        double newValue = Math.pow(this.getValue(), exponent);
        return (Q)this.withValue(newValue);
    }

    default public Q sqrt() {
        double newValue = Math.sqrt(this.getValue());
        return (Q)this.withValue(newValue);
    }

    default public Q log() {
        double value = this.getValue();
        if (value <= 0.0) {
            throw new UnitSystemArgumentException("Cannot calculate logarithm for non-positive value: " + value);
        }
        double newValue = Math.log(value);
        return (Q)this.withValue(newValue);
    }

    default public Q log10() {
        double value = this.getValue();
        if (value <= 0.0) {
            throw new UnitSystemArgumentException("Cannot calculate logarithm for non-positive value: " + value);
        }
        double newValue = Math.log10(value);
        return (Q)this.withValue(newValue);
    }

    default public Q ceil() {
        double newValue = Math.ceil(this.getValue());
        return (Q)this.withValue(newValue);
    }

    default public Q floor() {
        double newValue = Math.floor(this.getValue());
        return (Q)this.withValue(newValue);
    }

    default public Q roundHalfEven(int relevantDigits) {
        String formattedValue = ValueFormatter.toStringWithRelevantDigits(this.getValue(), relevantDigits);
        double newValue = Double.parseDouble(formattedValue);
        return (Q)this.withValue(newValue);
    }

    default public Q plus(PhysicalQuantity<U> inputQuantity) {
        if (inputQuantity == null) {
            return (Q)this.withValue(this.getValue());
        }
        Object sourceUnit = this.getUnitType();
        PhysicalQuantity<U> inputInSourceUnits = inputQuantity.toUnit(sourceUnit);
        double newValue = this.getValue() + inputInSourceUnits.getValue();
        return (Q)this.withValue(newValue);
    }

    default public Q minus(PhysicalQuantity<U> inputQuantity) {
        if (inputQuantity == null) {
            return (Q)this.withValue(this.getValue());
        }
        Object sourceUnit = this.getUnitType();
        PhysicalQuantity<U> inputInSourceUnits = inputQuantity.toUnit(sourceUnit);
        double newValue = this.getValue() - inputInSourceUnits.getValue();
        return (Q)this.withValue(newValue);
    }

    default public <V extends Unit, T extends PhysicalQuantity<V>> double multiply(T inputQuantity) {
        if (inputQuantity == null) {
            return this.getValue();
        }
        return this.getValue() * inputQuantity.getValue();
    }

    default public <V extends Unit, T extends PhysicalQuantity<V>> double times(T inputQuantity) {
        return this.multiply(inputQuantity);
    }

    default public <V extends Unit, T extends PhysicalQuantity<V>> double divide(T inputQuantity) {
        if (inputQuantity == null) {
            return this.getValue();
        }
        double thisValue = this.getValue();
        if (inputQuantity.getValue() == 0.0) {
            throw new UnitSystemArgumentException("Divider quantity value cannot be zero.");
        }
        return thisValue / inputQuantity.getValue();
    }

    default public <V extends Unit, T extends PhysicalQuantity<V>> double div(T inputQuantity) {
        return this.divide(inputQuantity);
    }

    default public <V extends Unit, T extends PhysicalQuantity<V>> double power(T inputQuantity) {
        if (inputQuantity == null) {
            return this.getValue();
        }
        double thisValue = this.getValue();
        return Math.pow(thisValue, inputQuantity.getValue());
    }
}

