/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files.apple;

import com.swoval.concurrent.ThreadFactory;
import com.swoval.files.apple.FileEvent;
import com.swoval.functional.Consumer;
import com.swoval.runtime.NativeLoader;
import com.swoval.runtime.ShutdownHooks;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class FileEventsApi
implements AutoCloseable {
    private long handle;
    private final ExecutorService executor = new ThreadPoolExecutor(2, 10, 5L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(8192), new ThreadFactory("com.swoval.files.apple.FileEventsApi.run-loop-thread"));
    private AtomicBoolean closed = new AtomicBoolean(false);

    private FileEventsApi(final Consumer<FileEvent> consumer, final Consumer<String> consumer2) throws InterruptedException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ShutdownHooks.addHook((int)1, (Runnable)new Runnable(){

            @Override
            public void run() {
                FileEventsApi.this.close();
            }
        });
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                Consumer<FileEvent> consumer3 = new Consumer<FileEvent>(){

                    @Override
                    public void accept(final FileEvent fileEvent) {
                        FileEventsApi.this.executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                consumer.accept(fileEvent);
                            }
                        });
                    }
                };
                Consumer<String> consumer22 = new Consumer<String>(){

                    @Override
                    public void accept(final String string) {
                        FileEventsApi.this.executor.submit(new Runnable(){

                            @Override
                            public void run() {
                                consumer2.accept(string);
                            }
                        });
                    }
                };
                FileEventsApi.this.handle = FileEventsApi.init(consumer3, consumer22);
                countDownLatch.countDown();
                FileEventsApi.this.loop();
            }
        });
        countDownLatch.await();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            FileEventsApi.stopLoop(this.handle);
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                FileEventsApi.close(this.handle);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void loop() {
        FileEventsApi.loop(this.handle);
    }

    public int createStream(String string, double d, int n) throws ClosedFileEventsApiException {
        if (this.closed.get()) {
            String string2 = "Tried to create watch stream for path " + string + " on closed watch service";
            throw new ClosedFileEventsApiException(string2);
        }
        return FileEventsApi.createStream(string, d, n, this.handle);
    }

    public void stopStream(int n) {
        if (!this.closed.get()) {
            FileEventsApi.stopStream(this.handle, n);
        }
    }

    public static FileEventsApi apply(Consumer<FileEvent> consumer, Consumer<String> consumer2) throws InterruptedException {
        return new FileEventsApi(consumer, consumer2);
    }

    private static native void loop(long var0);

    private static native void close(long var0);

    private static native long init(Consumer<FileEvent> var0, Consumer<String> var1);

    private static native int createStream(String var0, double var1, int var3, long var4);

    private static native void stopLoop(long var0);

    private static native void stopStream(long var0, int var2);

    static {
        try {
            NativeLoader.loadPackaged();
        }
        catch (IOException | UnsatisfiedLinkError throwable) {
            System.err.println("Couldn't load native library " + throwable);
            throw new ExceptionInInitializerError(throwable);
        }
    }

    public static class ClosedFileEventsApiException
    extends IOException {
        public ClosedFileEventsApiException(String string) {
            super(string);
        }
    }
}

