/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.QuickFile;
import com.swoval.files.QuickFileImpl;
import com.swoval.files.QuickLister;
import com.swoval.functional.Filter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

abstract class QuickListerImpl
implements QuickLister {
    static final int UNKNOWN = 0;
    static final int DIRECTORY = 1;
    static final int FILE = 2;
    static final int LINK = 4;
    static final int EOF = 8;
    static final int ENOENT = -1;
    static final int EACCES = -2;
    static final int ENOTDIR = -3;
    static final int ESUCCESS = -4;
    private static final Filter<Object> AllPass = new Filter<Object>(){

        @Override
        public boolean accept(Object object) {
            return true;
        }
    };

    QuickListerImpl() {
    }

    protected abstract ListResults listDir(String var1, boolean var2) throws IOException;

    @Override
    public final List<QuickFile> list(Path path, int n, boolean bl) throws IOException {
        return this.list(path, n, bl, AllPass);
    }

    @Override
    public final List<QuickFile> list(Path path, int n, boolean bl, Filter<? super QuickFile> filter) throws IOException {
        ArrayList<QuickFile> arrayList = new ArrayList<QuickFile>();
        HashSet<String> hashSet = bl && n > 0 ? new HashSet<String>() : null;
        this.listDirImpl(path.toString(), 1, n, bl, arrayList, filter, hashSet);
        return arrayList;
    }

    private void listDirImpl(String string, int n, int n2, boolean bl, List<QuickFile> list, Filter<? super QuickFile> filter, Set<String> set) throws IOException {
        Object object;
        Object object2;
        if (set != null) {
            set.add(string);
        }
        ListResults listResults = this.listDir(string, bl);
        for (String object32 : listResults.getDirectories()) {
            if (object32.equals(".") || object32.equals("..") || !filter.accept((QuickFile)(object2 = new QuickFileImpl((String)(object = string + File.separator + object32), 1)))) continue;
            list.add((QuickFile)object2);
            if (n >= n2) continue;
            this.listDirImpl((String)object, n + 1, n2, bl, list, filter, set);
        }
        Iterator<String> iterator = listResults.getFiles().iterator();
        while (iterator.hasNext()) {
            object = new QuickFileImpl(string + File.separator + iterator.next(), 2);
            if (!filter.accept((QuickFile)object)) continue;
            list.add((QuickFile)object);
        }
        object = listResults.getSymlinks().iterator();
        while (object.hasNext()) {
            BasicFileAttributes basicFileAttributes;
            int n3;
            object2 = string + File.separator + object.next();
            QuickFileImpl quickFileImpl = new QuickFileImpl((String)object2, n3 = (basicFileAttributes = bl ? Files.readAttributes(Paths.get((String)object2, new String[0]), BasicFileAttributes.class, new LinkOption[0]) : null) != null && basicFileAttributes.isDirectory() ? 5 : 6);
            if (!filter.accept(quickFileImpl)) continue;
            list.add(quickFileImpl);
            if ((n3 & 1) == 0 || n >= n2 || set == null) continue;
            if (set.add(quickFileImpl.toPath().toRealPath(new LinkOption[0]).toString())) {
                this.listDirImpl((String)object2, n + 1, n2, true, list, filter, set);
                continue;
            }
            throw new FileSystemLoopException((String)object2);
        }
    }

    static class ListResults {
        private final List<String> directories = new ArrayList<String>();
        private final List<String> files = new ArrayList<String>();
        private final List<String> symlinks = new ArrayList<String>();

        ListResults() {
        }

        List<String> getDirectories() {
            return this.directories;
        }

        List<String> getFiles() {
            return this.files;
        }

        List<String> getSymlinks() {
            return this.symlinks;
        }

        void addDir(String string) {
            this.directories.add(string);
        }

        void addFile(String string) {
            this.files.add(string);
        }

        void addSymlink(String string) {
            this.symlinks.add(string);
        }

        public String toString() {
            return "ListResults(\n  directories = " + this.directories + ",\n  files = " + this.files + ", \n  symlinks = " + this.symlinks + "\n)";
        }
    }
}

