/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.DirectoryLister;
import com.swoval.files.FileTreeView;
import com.swoval.files.LinkOption;
import com.swoval.files.NioWrappers;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.functional.Filter;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class SimpleFileTreeView
implements FileTreeView {
    static final int UNKNOWN = 8;
    static final int DIRECTORY = 1;
    static final int FILE = 2;
    static final int LINK = 4;
    static final int NONEXISTENT = 16;
    private static final boolean VERBOSE = System.getProperty("swoval.verbose", "false").equals("true");
    private final DirectoryLister directoryLister;
    private final boolean followLinks;
    private final boolean ignoreExceptions;

    SimpleFileTreeView(DirectoryLister directoryLister, boolean bl, boolean bl2) {
        this.directoryLister = directoryLister;
        this.followLinks = bl;
        this.ignoreExceptions = bl2;
    }

    SimpleFileTreeView(DirectoryLister directoryLister, boolean bl) {
        this(directoryLister, bl, false);
    }

    @Override
    public List<TypedPath> list(Path path, int n, Filter<? super TypedPath> filter) throws IOException {
        ArrayList<TypedPath> arrayList = new ArrayList<TypedPath>();
        if (n >= 0) {
            new Lister(filter, arrayList, this.followLinks, this.ignoreExceptions).fillResults(path, n);
        } else {
            TypedPath typedPath = TypedPaths.get(path);
            if (filter.accept(typedPath)) {
                arrayList.add(typedPath);
            }
        }
        return arrayList;
    }

    @Override
    public void close() {
    }

    private static int getSymbolicLinkTargetKind(Path path, boolean bl) throws IOException {
        if (bl) {
            try {
                BasicFileAttributes basicFileAttributes = NioWrappers.readAttributes(path, new LinkOption[0]);
                return 4 | (basicFileAttributes.isDirectory() ? 1 : (basicFileAttributes.isRegularFile() ? 2 : 8));
            }
            catch (NoSuchFileException noSuchFileException) {
                return 16;
            }
        }
        return 4;
    }

    private static int decrement(int n) {
        return n == Integer.MAX_VALUE ? n : n - 1;
    }

    private class Lister {
        final List<TypedPath> result;
        final Set<Path> visited = new HashSet<Path>();
        final Filter<? super TypedPath> filter;
        final boolean followLinks;
        final boolean ignoreExceptions;

        Lister(Filter<? super TypedPath> filter, List<TypedPath> list, boolean bl, boolean bl2) {
            this.filter = filter;
            this.followLinks = bl;
            this.result = list;
            this.ignoreExceptions = bl2;
        }

        void fillResults(Path path, int n) throws IOException {
            try {
                this.impl(path, n);
            }
            finally {
                this.visited.clear();
            }
        }

        private void impl(Path path, int n) throws IOException {
            block8: {
                try {
                    Object object;
                    Object object2;
                    ListResults listResults = SimpleFileTreeView.this.directoryLister.apply(path.toAbsolutePath().toString(), this.followLinks);
                    this.visited.add(path);
                    for (String object32 : listResults.getDirectories()) {
                        if (object32.equals(".") || object32.equals("..")) continue;
                        object2 = Paths.get(path + File.separator + object32, new String[0]);
                        object = TypedPaths.get((Path)object2, 1);
                        if (this.filter.accept((TypedPath)object)) {
                            this.result.add((TypedPath)object);
                        }
                        if (n <= 0) continue;
                        this.fillResults((Path)object2, SimpleFileTreeView.decrement(n));
                    }
                    Iterator<String> iterator = listResults.getFiles().iterator();
                    while (iterator.hasNext()) {
                        object2 = TypedPaths.get(Paths.get(path + File.separator + iterator.next(), new String[0]), 2);
                        if (!this.filter.accept((TypedPath)object2)) continue;
                        this.result.add((TypedPath)object2);
                    }
                    object2 = listResults.getSymlinks().iterator();
                    while (object2.hasNext()) {
                        object = Paths.get(path + File.separator + object2.next(), new String[0]);
                        TypedPath typedPath = TypedPaths.get((Path)object, SimpleFileTreeView.getSymbolicLinkTargetKind((Path)object, this.followLinks));
                        if (this.filter.accept(typedPath)) {
                            this.result.add(typedPath);
                        }
                        if (!typedPath.isDirectory() || n <= 0) continue;
                        if (this.visited.add(typedPath.getPath().toRealPath(new java.nio.file.LinkOption[0]))) {
                            this.fillResults((Path)object, SimpleFileTreeView.decrement(n));
                            continue;
                        }
                        if (!VERBOSE) continue;
                        System.err.println("Detected symlink loop for path " + typedPath.getPath());
                    }
                }
                catch (IOException iOException) {
                    if (this.ignoreExceptions) break block8;
                    throw iOException;
                }
            }
        }
    }

    static class ListResults {
        private final List<String> directories = new ArrayList<String>();
        private final List<String> files = new ArrayList<String>();
        private final List<String> symlinks = new ArrayList<String>();

        ListResults() {
        }

        List<String> getDirectories() {
            return this.directories;
        }

        List<String> getFiles() {
            return this.files;
        }

        List<String> getSymlinks() {
            return this.symlinks;
        }

        void addDir(String string) {
            this.directories.add(string);
        }

        void addFile(String string) {
            this.files.add(string);
        }

        void addSymlink(String string) {
            this.symlinks.add(string);
        }

        public String toString() {
            return "ListResults(\n  directories = " + this.directories + ",\n  files = " + this.files + ", \n  symlinks = " + this.symlinks + "\n)";
        }
    }
}

