/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.CachedDirectoryImpl;
import com.swoval.files.DirectoryLister;
import com.swoval.files.DirectoryListers;
import com.swoval.files.DirectoryView;
import com.swoval.files.Entries;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeView;
import com.swoval.files.NioDirectoryLister;
import com.swoval.files.SimpleFileTreeView;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.functional.Filter;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FileTreeViews {
    private static final DirectoryLister nioDirectoryLister;
    private static final DirectoryLister nativeDirectoryLister;
    private static final DirectoryLister defaultDirectoryLister;
    private static final FileTreeView defaultFileTreeView;
    private static final FileTreeDataViews.Converter<Path> PATH_CONVERTER;

    private FileTreeViews() {
    }

    public static DirectoryView cached(Path path, int n, boolean bl) throws IOException {
        return new CachedDirectoryImpl<Path>(TypedPaths.get(path), PATH_CONVERTER, n, Filters.AllPass, bl).init();
    }

    public static FileTreeView getNio(boolean bl) {
        return new SimpleFileTreeView(nioDirectoryLister, bl);
    }

    public static FileTreeView getNative(boolean bl) {
        return new SimpleFileTreeView(nativeDirectoryLister, bl);
    }

    public static FileTreeView getDefault(boolean bl) {
        return new SimpleFileTreeView(defaultDirectoryLister, bl, false);
    }

    static FileTreeView getDefault(boolean bl, boolean bl2) {
        return new SimpleFileTreeView(defaultDirectoryLister, bl, bl2);
    }

    public static List<TypedPath> list(Path path, int n, Filter<? super TypedPath> filter) throws IOException {
        return defaultFileTreeView.list(path, n, filter);
    }

    static {
        DirectoryLister directoryLister;
        DirectoryLister[] directoryListerArray = DirectoryListers.init();
        nativeDirectoryLister = directoryListerArray[0];
        NioDirectoryLister nioDirectoryLister = new NioDirectoryLister();
        FileTreeViews.nioDirectoryLister = nioDirectoryLister;
        defaultDirectoryLister = directoryLister = directoryListerArray[1] != null ? directoryListerArray[1] : (directoryListerArray[0] != null ? directoryListerArray[0] : nioDirectoryLister);
        defaultFileTreeView = new SimpleFileTreeView(directoryLister, false);
        PATH_CONVERTER = new FileTreeDataViews.Converter<Path>(){

            @Override
            public Path apply(TypedPath typedPath) {
                return typedPath.getPath();
            }
        };
    }

    static class Updates<T>
    implements FileTreeDataViews.CacheObserver<T> {
        private final List<FileTreeDataViews.Entry<T>> creations = new ArrayList<FileTreeDataViews.Entry<T>>();
        private final List<FileTreeDataViews.Entry<T>> deletions = new ArrayList<FileTreeDataViews.Entry<T>>();
        private final List<FileTreeDataViews.Entry<T>[]> updates = new ArrayList<FileTreeDataViews.Entry<T>[]>();

        Updates() {
        }

        void observe(FileTreeDataViews.CacheObserver<T> cacheObserver) {
            Iterator<FileTreeDataViews.Entry<T>> iterator = this.creations.iterator();
            while (iterator.hasNext()) {
                cacheObserver.onCreate(iterator.next());
            }
            for (FileTreeDataViews.Entry<T>[] object2 : this.updates) {
                cacheObserver.onUpdate(object2[0], object2[1]);
            }
            Iterator<FileTreeDataViews.Entry<T>> iterator2 = this.deletions.iterator();
            while (iterator2.hasNext()) {
                cacheObserver.onDelete(Entries.setExists(iterator2.next(), false));
            }
        }

        @Override
        public void onCreate(FileTreeDataViews.Entry<T> entry) {
            this.creations.add(entry);
        }

        @Override
        public void onDelete(FileTreeDataViews.Entry<T> entry) {
            this.deletions.add(entry);
        }

        @Override
        public void onUpdate(FileTreeDataViews.Entry<T> entry, FileTreeDataViews.Entry<T> entry2) {
            this.updates.add(new FileTreeDataViews.Entry[]{entry, entry2});
        }

        @Override
        public void onError(IOException iOException) {
        }

        public String toString() {
            ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
            Iterator<FileTreeDataViews.Entry<T>[]> iterator = this.updates.iterator();
            while (iterator.hasNext()) {
                arrayList.add(Arrays.asList((Object[])iterator.next()));
            }
            return "Updates(" + "creations: " + this.creations + ", deletions: " + this.deletions + ", updates: " + arrayList + ")";
        }
    }

    public static interface Observable<T> {
        public int addObserver(Observer<? super T> var1);

        public void removeObserver(int var1);
    }

    public static interface Observer<T> {
        public void onError(Throwable var1);

        public void onNext(T var1);
    }
}

