/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.CachedDirectoryImpl;
import com.swoval.files.DirectoryDataView;
import com.swoval.files.FileTreeViews;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.functional.Either;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.nio.file.Path;

public class FileTreeDataViews {
    private FileTreeDataViews() {
    }

    public static <T> DirectoryDataView<T> cached(Path path, Converter<T> converter, int n, boolean bl) throws IOException {
        return new CachedDirectoryImpl<T>(TypedPaths.get(path), converter, n, Filters.AllPass, bl).init();
    }

    public static interface ObservableCache<T>
    extends FileTreeViews.Observable<Entry<T>> {
        public int addCacheObserver(CacheObserver<T> var1);
    }

    public static interface CacheObserver<T> {
        public void onCreate(Entry<T> var1);

        public void onDelete(Entry<T> var1);

        public void onUpdate(Entry<T> var1, Entry<T> var2);

        public void onError(IOException var1);
    }

    public static interface Converter<R> {
        public R apply(TypedPath var1) throws IOException;
    }

    public static interface Entry<T>
    extends Comparable<Entry<T>> {
        public TypedPath getTypedPath();

        public Either<IOException, T> getValue();
    }
}

