/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile.plugin.at_generated;

import com.sun.codemodel.JAnnotatable;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JPackage;
import com.sun.tools.ws.ToolVersion;
import com.sun.tools.ws.processor.model.Model;
import com.sun.tools.ws.wscompile.BadCommandLineException;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import com.sun.tools.ws.wscompile.Options;
import com.sun.tools.ws.wscompile.Plugin;
import com.sun.tools.ws.wscompile.WsimportOptions;
import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import org.xml.sax.SAXException;

public final class PluginImpl
extends Plugin {
    private JClass annotation;
    private boolean noDate = false;
    private String genAnnotation = "javax.annotation.Generated";
    private String date = null;

    @Override
    public String getOptionName() {
        return "mark-generated";
    }

    @Override
    public String getUsage() {
        return "  -mark-generated                  mark the generated code as @javax.annotation.Generated\n              -noDate              do not add date\n              -Xann <annotation>   generate <annotation> instead of @javax.annotation.Generated";
    }

    @Override
    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        if ("-noDate".equals(args[i])) {
            this.noDate = true;
            return 1;
        }
        if ("-Xann".equals(args[i])) {
            this.genAnnotation = opt.requireArgument("-Xann", args, ++i);
            return 2;
        }
        return 0;
    }

    @Override
    public boolean run(Model model, WsimportOptions wo, ErrorReceiver er) throws SAXException {
        JCodeModel cm = wo.getCodeModel();
        this.annotation = cm.ref(this.genAnnotation);
        Iterator i = cm.packages();
        while (i.hasNext()) {
            Iterator j = ((JPackage)i.next()).classes();
            while (j.hasNext()) {
                this.annotateCls((JDefinedClass)j.next());
            }
        }
        return true;
    }

    private void annotateCls(JDefinedClass cls) {
        this.annotate((JAnnotatable)cls);
        Iterator c = cls.classes();
        while (c.hasNext()) {
            this.annotateCls((JDefinedClass)c.next());
        }
    }

    private void annotate(JAnnotatable m) {
        JAnnotationUse au = m.annotate(this.annotation).param("value", WsimportTool.class.getName()).param("comments", ToolVersion.VERSION.BUILD_VERSION);
        if (!this.noDate) {
            au.param("date", this.getISO8601Date());
        }
    }

    private String getISO8601Date() {
        if (this.date == null) {
            ZonedDateTime zdt = ZonedDateTime.now().withNano(0);
            this.date = zdt.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        return this.date;
    }
}

