/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2017 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.xml.ws.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import javax.annotation.Generated;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
@Generated("com.sun.istack.maven.ResourceGenMojo")
public final class ProviderApiMessages {

    private final static String BUNDLE_NAME = "com.sun.xml.ws.resources.providerApi";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new ProviderApiMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableNULL_SERVICE() {
        return MESSAGE_FACTORY.getMessage("null.service");
    }

    /**
     * serviceName can't be null when portName is specified
     * 
     */
    public static String NULL_SERVICE() {
        return LOCALIZER.localize(localizableNULL_SERVICE());
    }

    public static Localizable localizableNULL_ADDRESS_SERVICE_ENDPOINT() {
        return MESSAGE_FACTORY.getMessage("null.address.service.endpoint");
    }

    /**
     * Address in an EPR cannot be null, when serviceName or portName is null
     * 
     */
    public static String NULL_ADDRESS_SERVICE_ENDPOINT() {
        return LOCALIZER.localize(localizableNULL_ADDRESS_SERVICE_ENDPOINT());
    }

    public static Localizable localizableNULL_PORTNAME() {
        return MESSAGE_FACTORY.getMessage("null.portname");
    }

    /**
     * EPR doesn't have EndpointName in the Metadata
     * 
     */
    public static String NULL_PORTNAME() {
        return LOCALIZER.localize(localizableNULL_PORTNAME());
    }

    public static Localizable localizableNULL_WSDL() {
        return MESSAGE_FACTORY.getMessage("null.wsdl");
    }

    /**
     * EPR doesn't have WSDL Metadata which is needed for the current operation
     * 
     */
    public static String NULL_WSDL() {
        return LOCALIZER.localize(localizableNULL_WSDL());
    }

    public static Localizable localizableNO_WSDL_NO_PORT(Object arg0) {
        return MESSAGE_FACTORY.getMessage("no.wsdl.no.port", arg0);
    }

    /**
     * WSDL Metadata not available to create the proxy, either Service instance or ServiceEndpointInterface {0} should have WSDL information  
     * 
     */
    public static String NO_WSDL_NO_PORT(Object arg0) {
        return LOCALIZER.localize(localizableNO_WSDL_NO_PORT(arg0));
    }

    public static Localizable localizableNOTFOUND_PORT_IN_WSDL(Object arg0, Object arg1, Object arg2) {
        return MESSAGE_FACTORY.getMessage("notfound.port.in.wsdl", arg0, arg1, arg2);
    }

    /**
     * Port: {0} not a valid port in Service: {1} in WSDL: {2}
     * 
     */
    public static String NOTFOUND_PORT_IN_WSDL(Object arg0, Object arg1, Object arg2) {
        return LOCALIZER.localize(localizableNOTFOUND_PORT_IN_WSDL(arg0, arg1, arg2));
    }

    public static Localizable localizableNOTFOUND_SERVICE_IN_WSDL(Object arg0, Object arg1) {
        return MESSAGE_FACTORY.getMessage("notfound.service.in.wsdl", arg0, arg1);
    }

    /**
     * Service: {0} not found in WSDL: {1}
     * 
     */
    public static String NOTFOUND_SERVICE_IN_WSDL(Object arg0, Object arg1) {
        return LOCALIZER.localize(localizableNOTFOUND_SERVICE_IN_WSDL(arg0, arg1));
    }

    public static Localizable localizableNULL_EPR() {
        return MESSAGE_FACTORY.getMessage("null.epr");
    }

    /**
     * EndpointReference is null
     * 
     */
    public static String NULL_EPR() {
        return LOCALIZER.localize(localizableNULL_EPR());
    }

    public static Localizable localizableNULL_ADDRESS() {
        return MESSAGE_FACTORY.getMessage("null.address");
    }

    /**
     * Address in an EPR cannot be null
     * 
     */
    public static String NULL_ADDRESS() {
        return LOCALIZER.localize(localizableNULL_ADDRESS());
    }

    public static Localizable localizableERROR_WSDL(Object arg0) {
        return MESSAGE_FACTORY.getMessage("error.wsdl", arg0);
    }

    /**
     * Error in parsing WSDL: {0}
     * 
     */
    public static String ERROR_WSDL(Object arg0) {
        return LOCALIZER.localize(localizableERROR_WSDL(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
