/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.local;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.transport.local.ClosedCallback;
import com.sun.xml.ws.util.ByteArrayBuffer;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalConnectionImpl
extends WSHTTPConnection
implements WebServiceContextDelegate {
    private final Map<String, List<String>> reqHeaders;
    private Map<String, List<String>> rspHeaders = null;
    protected int statusCode;
    private ByteArrayBuffer baos;
    private final URI baseURI;
    private final ClosedCallback callback;
    private static final PropertySet.PropertyMap model = LocalConnectionImpl.parse(LocalConnectionImpl.class);

    LocalConnectionImpl(URI baseURI, @NotNull Map<String, List<String>> reqHeaders) {
        this(baseURI, reqHeaders, null);
    }

    LocalConnectionImpl(URI baseURI, @NotNull Map<String, List<String>> reqHeaders, @Nullable ClosedCallback callback) {
        this.baseURI = baseURI;
        this.reqHeaders = reqHeaders;
        this.callback = callback;
    }

    @NotNull
    public InputStream getInput() {
        return this.baos.newInputStream();
    }

    @NotNull
    public OutputStream getOutput() {
        this.baos = new ByteArrayBuffer();
        return this.baos;
    }

    public String toString() {
        return this.baos.toString();
    }

    @NotNull
    public WebServiceContextDelegate getWebServiceContextDelegate() {
        return this;
    }

    public Principal getUserPrincipal(Packet request) {
        return null;
    }

    public boolean isUserInRole(Packet request, String role) {
        return false;
    }

    @NotNull
    public String getEPRAddress(Packet request, WSEndpoint endpoint) {
        return this.baseURI.resolve("?" + endpoint.getPortName().getLocalPart()).toString();
    }

    public String getWSDLAddress(@NotNull Packet request, @NotNull WSEndpoint endpoint) {
        ServiceDefinition sd = endpoint.getServiceDefinition();
        if (sd != null) {
            return sd.getPrimary().getURL().toString();
        }
        return null;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.method"})
    @NotNull
    public String getRequestMethod() {
        return "POST";
    }

    public boolean isSecure() {
        return false;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.querystring"})
    public String getQueryString() {
        return null;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.pathinfo"})
    public String getPathInfo() {
        return null;
    }

    @NotNull
    public String getBaseAddress() {
        return null;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.code"})
    public int getStatus() {
        return this.statusCode;
    }

    public void setStatus(int statusCode) {
        this.statusCode = statusCode;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.response.headers", "com.sun.xml.ws.api.message.packet.outbound.transport.headers"})
    @Nullable
    public Map<String, List<String>> getResponseHeaders() {
        return this.rspHeaders;
    }

    @PropertySet.Property(value={"javax.xml.ws.http.request.headers", "com.sun.xml.ws.api.message.packet.inbound.transport.headers"})
    @NotNull
    public Map<String, List<String>> getRequestHeaders() {
        return this.reqHeaders;
    }

    public String getRequestHeader(String headerName) {
        List<String> values = this.getRequestHeaders().get(headerName);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public void setResponseHeaders(Map<String, List<String>> headers) {
        if (headers == null) {
            this.rspHeaders = new HashMap<String, List<String>>();
        } else {
            this.rspHeaders = new HashMap<String, List<String>>(headers);
            Iterator<String> itr = this.rspHeaders.keySet().iterator();
            while (itr.hasNext()) {
                String key = itr.next();
                if (!key.equalsIgnoreCase("Content-Type") && !key.equalsIgnoreCase("Content-Length")) continue;
                itr.remove();
            }
        }
    }

    public void setContentTypeResponseHeader(@NotNull String value) {
        if (this.rspHeaders == null) {
            this.rspHeaders = new HashMap<String, List<String>>();
        }
        this.rspHeaders.put("Content-Type", Collections.singletonList(value));
    }

    public void close() {
        if (!this.isClosed()) {
            super.close();
            if (this.callback != null) {
                this.callback.onClosed();
            }
        }
    }

    protected PropertySet.PropertyMap getPropertyMap() {
        return model;
    }
}

