/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.JdkVersion;
import com.sun.grizzly.util.LoggerUtils;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStructures {
    private static final Class<?> LTQclass;

    private static Class<?> getAndVerify(String cname) throws Throwable {
        Class<?> cl = DataStructures.class.getClassLoader().loadClass(cname);
        return cl.newInstance().getClass();
    }

    public static BlockingQueue<?> getLTQinstance() {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> BlockingQueue<T> getLTQinstance(Class<T> t) {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static Queue<?> getCLQinstance() {
        return new ConcurrentLinkedQueue();
    }

    public static <T> Queue<T> getCLQinstance(Class<T> t) {
        return new ConcurrentLinkedQueue();
    }

    static {
        Class<Object> c;
        String className = null;
        try {
            JdkVersion jdkVersion = JdkVersion.getJdkVersion();
            JdkVersion minimumVersion = JdkVersion.parseVersion("1.7.0");
            className = minimumVersion.compareTo(jdkVersion) <= 0 ? "java.util.concurrent.LinkedTransferQueue" : "com.sun.grizzly.util.LinkedTransferQueue";
            c = DataStructures.getAndVerify(className);
            LoggerUtils.getLogger().log(Level.FINE, "USING LTQ class:{0}", c);
        }
        catch (Throwable t) {
            LoggerUtils.getLogger().log(Level.FINE, "failed loading datastructure class:" + className + " fallback to embedded one", t);
            c = LinkedBlockingQueue.class;
        }
        LTQclass = c;
    }
}

