/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.LoggerUtils;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataStructures {
    private static final Class<?> LTQclass;
    private static final Class<?> CLQclass;

    private static Class<?> getAndVerify(String cname) throws Throwable {
        Class<?> cl = DataStructures.class.getClassLoader().loadClass(cname);
        return cl.newInstance().getClass();
    }

    public static BlockingQueue<?> getLTQinstance() {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> BlockingQueue<T> getLTQinstance(Class<T> t) {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static Queue<?> getCLQinstance() {
        try {
            return (Queue)CLQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> Queue<T> getCLQinstance(Class<T> t) {
        try {
            return (Queue)CLQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    static {
        Class LTQ = LinkedBlockingQueue.class;
        Class CLQ = LinkedBlockingQueue.class;
        int jver = 0;
        try {
            jver = Integer.valueOf(System.getProperty("java.version").substring(0, 3).replace(".", ""));
            if (jver > 16) {
                CLQ = ConcurrentLinkedQueue.class;
                LTQ = DataStructures.getAndVerify("maskedclasses.LinkedTransferQueue");
            } else if (jver == 16) {
                LTQ = DataStructures.getAndVerify("maskedclasses.LinkedTransferQueue");
                CLQ = DataStructures.getAndVerify("maskedclasses.ConcurrentLinkedQueue");
            }
        }
        catch (Throwable t) {
            LoggerUtils.getLogger().log(Level.FINE, "failed loading grizzly version of datastructure classes, dont worry we load other classes instead.", t);
        }
        LTQclass = LTQ;
        CLQclass = CLQ;
        LoggerUtils.getLogger().log(Level.FINE, "JVM version {0} detected, grizzly loaded datastructure classes: {1} {2}", new Object[]{jver, LTQclass, CLQclass});
    }
}

