/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.standalone;

import com.sun.grizzly.http.Constants;
import com.sun.grizzly.http.FileCache;
import com.sun.grizzly.http.WebFilter;
import com.sun.grizzly.http.WebFilterConfig;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.streams.StreamWriter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.util.Interceptor;
import com.sun.grizzly.util.buf.Ascii;
import com.sun.grizzly.util.buf.ByteChunk;
import com.sun.grizzly.util.buf.MessageBytes;
import com.sun.grizzly.util.http.MimeHeaders;
import java.io.IOException;

public class StaticHandler
implements Interceptor<Request> {
    private WebFilter webFilter;
    private StreamReader reader;
    private StreamWriter writer;
    protected FileCache fileCache;

    public StaticHandler(WebFilter webFilter) {
        this.webFilter = webFilter;
    }

    public void attach(StreamReader reader, StreamWriter writer) {
        this.reader = reader;
        this.writer = writer;
        if (this.fileCache == null && writer != null) {
            this.fileCache = ((WebFilterConfig)this.webFilter.getConfig()).getFileCache();
        }
    }

    public int handle(Request req, int handlerCode) throws IOException {
        ByteChunk requestURI;
        if (this.fileCache == null) {
            return 0;
        }
        if (handlerCode == 1 && this.fileCache.isEnabled()) {
            String docroot = ((WebFilterConfig)this.webFilter.getConfig()).getWebAppRootPath();
            MessageBytes mb = req.requestURI();
            String uri = req.requestURI().toString();
            this.fileCache.add("default", docroot, uri, req.getResponse().getMimeHeaders(), false);
        } else if (handlerCode == 0 && this.fileCache.sendCache((requestURI = req.requestURI().getByteChunk()).getBytes(), requestURI.getStart(), requestURI.getLength(), this.writer, this.keepAlive(req))) {
            return 1;
        }
        return 0;
    }

    private boolean keepAlive(Request request) {
        MimeHeaders headers = request.getMimeHeaders();
        MessageBytes connectionValueMB = headers.getValue("connection");
        if (connectionValueMB != null) {
            ByteChunk connectionValueBC = connectionValueMB.getByteChunk();
            if (this.findBytes(connectionValueBC, Constants.CLOSE_BYTES) != -1) {
                return false;
            }
            if (this.findBytes(connectionValueBC, Constants.KEEPALIVE_BYTES) != -1) {
                return true;
            }
        }
        return true;
    }

    protected int findBytes(ByteChunk bc, byte[] b) {
        byte first = b[0];
        byte[] buff = bc.getBuffer();
        int start = bc.getStart();
        int end = bc.getEnd();
        int srcEnd = b.length;
        for (int i = start; i <= end - srcEnd; ++i) {
            if (Ascii.toLower((int)buff[i]) != first) continue;
            int myPos = i + 1;
            int srcPos = 1;
            while (srcPos < srcEnd && Ascii.toLower((int)buff[myPos++]) == b[srcPos++]) {
                if (srcPos != srcEnd) continue;
                return i - start;
            }
        }
        return -1;
    }
}

