/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.AbstractTransformer;
import com.sun.grizzly.Buffer;
import com.sun.grizzly.TransformationException;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeStorage;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringDecoder
extends AbstractTransformer<Buffer, String> {
    protected Charset charset;
    protected Attribute<Integer> stateAttribute;
    protected byte[] stringTerminateBytes = null;

    public StringDecoder() {
        this((String)null);
    }

    public StringDecoder(String stringTerminator) {
        this(Charset.forName("UTF-8"), stringTerminator);
    }

    public StringDecoder(Charset charset) {
        this(charset, null);
    }

    public StringDecoder(Charset charset, String stringTerminator) {
        this.charset = charset;
        if (stringTerminator != null) {
            try {
                this.stringTerminateBytes = stringTerminator.getBytes(charset.name());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.stateAttribute = this.attributeBuilder.createAttribute("StringDecoder.StringSize");
    }

    @Override
    public TransformationResult<String> transform(AttributeStorage storage, Buffer input, String output) throws TransformationException {
        if (input == null) {
            throw new TransformationException("Input could not be null");
        }
        if (this.stringTerminateBytes == null) {
            return this.parseWithLengthPrefix(storage, input);
        }
        return this.parseWithTerminatingSeq(storage, input);
    }

    protected TransformationResult<String> parseWithLengthPrefix(AttributeStorage storage, Buffer input) {
        Integer stringSize = this.stateAttribute.get(storage);
        if (stringSize == null) {
            if (input.remaining() < 2) {
                this.saveState(storage, incompletedResult, null);
                return incompletedResult;
            }
            stringSize = input.getShort();
        }
        if (input.remaining() < stringSize) {
            this.saveState(storage, incompletedResult, stringSize);
            return incompletedResult;
        }
        int tmpLimit = input.limit();
        input.limit(input.position() + stringSize);
        String stringMessage = input.contentAsString(this.charset);
        input.position(input.limit());
        input.limit(tmpLimit);
        TransformationResult<String> result = new TransformationResult<String>(TransformationResult.Status.COMPLETED, stringMessage);
        this.saveState(storage, result, stringSize);
        return result;
    }

    protected TransformationResult<String> parseWithTerminatingSeq(AttributeStorage storage, Buffer input) {
        TransformationResult<String> result;
        int terminationBytesLength = this.stringTerminateBytes.length;
        int checkIndex = 0;
        int termIndex = -1;
        Integer offsetInt = this.stateAttribute.get(storage);
        int offset = 0;
        if (offsetInt != null) {
            offset = offsetInt;
        }
        for (int i = input.position() + offset; i < input.limit(); ++i) {
            if (input.get(i) != this.stringTerminateBytes[checkIndex] || ++checkIndex < terminationBytesLength) continue;
            termIndex = i - terminationBytesLength + 1;
            break;
        }
        if (termIndex >= 0) {
            int tmpLimit = input.limit();
            input.limit(termIndex);
            String stringMessage = input.contentAsString(this.charset);
            input.limit(tmpLimit);
            input.position(termIndex + terminationBytesLength);
            result = new TransformationResult<String>(TransformationResult.Status.COMPLETED, stringMessage);
        } else {
            offset = input.remaining() - terminationBytesLength;
            if (offset < 0) {
                offset = 0;
            }
            result = incompletedResult;
        }
        this.saveState(storage, result, offset);
        return result;
    }

    @Override
    public void release(AttributeStorage storage) {
        this.stateAttribute.remove(storage);
        super.release(storage);
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    protected void saveState(AttributeStorage storage, TransformationResult<String> result, Integer state) {
        this.lastResultAttribute.set(storage, result);
        this.stateAttribute.set(storage, state);
    }
}

