/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.utils.conditions.Condition;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MinBufferSizeCondition
implements Condition<ReadResult<Buffer, ?>> {
    private Logger logger = Grizzly.logger;
    public static final int FULL_BUFFER = -1;
    private int minSize;

    public MinBufferSizeCondition() {
        this(-1);
    }

    public MinBufferSizeCondition(int minSize) {
        this.minSize = minSize;
    }

    @Override
    public boolean check(ReadResult<Buffer, ?> currentResult) {
        Buffer message = currentResult.getMessage();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("check result. MinSize=" + this.minSize + " Result=" + currentResult + " message=" + message);
        }
        if (message == null) {
            return false;
        }
        if (this.minSize > -1) {
            return message.remaining() >= this.minSize;
        }
        return message.remaining() == message.capacity();
    }
}

