/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.utils;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.Transformer;
import com.sun.grizzly.filterchain.FilterAdapter;
import com.sun.grizzly.filterchain.FilterChainContext;
import com.sun.grizzly.filterchain.NextAction;
import com.sun.grizzly.streams.AddressableStreamReader;
import com.sun.grizzly.streams.AddressableStreamWriter;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.streams.StreamWriter;
import java.io.IOException;
import java.util.logging.Logger;

public class EchoFilter
extends FilterAdapter {
    private static final Logger logger = Grizzly.logger;

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        if (message != null) {
            Connection connection = ctx.getConnection();
            Transformer encoder = ctx.getFilterChain().getCodec().getEncoder();
            TransformationResult<Object> result = encoder.transform(connection, message, null);
            encoder.release(connection);
            Buffer buffer = result.getMessage();
            Object address = ctx.getAddress();
            connection.write(address, buffer);
        } else {
            StreamReader reader = ctx.getStreamReader();
            StreamWriter writer = ctx.getStreamWriter();
            if (writer instanceof AddressableStreamWriter) {
                AddressableStreamReader addressableReader = (AddressableStreamReader)reader;
                addressableReader.getBuffer();
                Object peerAddress = addressableReader.getPeerAddress();
                AddressableStreamWriter addressableWriter = (AddressableStreamWriter)writer;
                if (addressableWriter.getPeerAddress() == null) {
                    addressableWriter.setPeerAddress(peerAddress);
                }
            }
            writer.writeStream(reader);
            writer.flush();
        }
        return nextAction;
    }
}

