/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.streams;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.impl.FutureImpl;
import com.sun.grizzly.impl.ReadyFutureImpl;
import com.sun.grizzly.streams.AbstractStreamReader;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.utils.conditions.Condition;
import java.io.EOFException;
import java.util.concurrent.Future;

public abstract class StreamReaderDecorator
extends AbstractStreamReader {
    protected StreamReader underlyingReader;

    public StreamReaderDecorator(StreamReader underlyingReader) {
        this.setUnderlyingReader(underlyingReader);
    }

    public StreamReader getUnderlyingReader() {
        return this.underlyingReader;
    }

    public void setUnderlyingReader(StreamReader underlyingReader) {
        this.underlyingReader = underlyingReader;
    }

    @Override
    public boolean isBlocking() {
        return this.underlyingReader.isBlocking();
    }

    @Override
    public void setBlocking(boolean isBlocking) {
        this.underlyingReader.setBlocking(isBlocking);
    }

    @Override
    public Connection getConnection() {
        if (this.underlyingReader != null) {
            return this.underlyingReader.getConnection();
        }
        return null;
    }

    @Override
    public Future<Integer> notifyCondition(Condition<StreamReader> condition, CompletionHandler<Integer> completionHandler) {
        if (this.notifyObject != null) {
            throw new IllegalStateException("Only one available listener allowed!");
        }
        if (this.isClosed()) {
            EOFException exception = new EOFException();
            if (completionHandler != null) {
                completionHandler.failed(null, exception);
            }
            return new ReadyFutureImpl<Integer>(exception);
        }
        int availableDataSize = this.availableDataSize();
        if (condition.check(this)) {
            if (completionHandler != null) {
                completionHandler.completed(null, availableDataSize);
            }
            return new ReadyFutureImpl<Integer>(availableDataSize);
        }
        FutureImpl<Integer> future = new FutureImpl<Integer>();
        this.notifyObject = new AbstractStreamReader.NotifyObject(future, completionHandler, condition);
        this.underlyingReader.notifyAvailable(1, new FeederCompletionHandler(future, completionHandler));
        return future;
    }

    public void pull() {
        Buffer buffer;
        if (this.underlyingReader == null) {
            return;
        }
        if (this.underlyingReader instanceof StreamReaderDecorator) {
            ((StreamReaderDecorator)this.underlyingReader).pull();
        }
        while ((buffer = this.underlyingReader.getBuffer()) != null) {
            boolean wasAdded = this.appendBuffer(buffer);
            if (wasAdded) {
                this.underlyingReader.finishBuffer();
                continue;
            }
            return;
        }
    }

    protected class FeederCompletionHandler
    implements CompletionHandler {
        private final FutureImpl future;
        private final CompletionHandler completionHandler;

        public FeederCompletionHandler(FutureImpl future, CompletionHandler completionHandler) {
            this.future = future;
            this.completionHandler = completionHandler;
        }

        @Override
        public void cancelled(Connection connection) {
            if (this.completionHandler != null) {
                this.completionHandler.cancelled(connection);
            }
            this.future.cancel(true);
        }

        @Override
        public void failed(Connection connection, Throwable throwable) {
            if (this.completionHandler != null) {
                this.completionHandler.failed(connection, throwable);
            }
            this.future.failure(throwable);
        }

        public void completed(Connection connection, Object result) {
            Buffer buffer = StreamReaderDecorator.this.underlyingReader.getBuffer();
            if (StreamReaderDecorator.this.appendBuffer(buffer)) {
                StreamReaderDecorator.this.underlyingReader.finishBuffer();
            }
            if (!this.future.isDone()) {
                StreamReaderDecorator.this.underlyingReader.notifyAvailable(1, this);
            }
        }

        public void updated(Connection connection, Object result) {
        }
    }
}

