/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Buffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;

public class SSLUtils {
    public static SSLEngineResult unwrap(SSLEngine sslEngine, Buffer securedInBuffer, Buffer plainBuffer) throws IOException {
        return sslEngine.unwrap((ByteBuffer)securedInBuffer.underlying(), (ByteBuffer)plainBuffer.underlying());
    }

    public static SSLEngineResult wrap(SSLEngine sslEngine, Buffer plainBuffer, Buffer securedOutBuffer) throws IOException {
        return sslEngine.wrap((ByteBuffer)plainBuffer.underlying(), (ByteBuffer)securedOutBuffer.underlying());
    }

    public static void executeDelegatedTask(SSLEngine sslEngine) {
        Runnable runnable;
        while ((runnable = sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
    }

    public static boolean isHandshaking(SSLEngine sslEngine) {
        SSLEngineResult.HandshakeStatus handshakeStatus = sslEngine.getHandshakeStatus();
        return handshakeStatus != SSLEngineResult.HandshakeStatus.FINISHED && handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
    }

    static void clearOrCompact(Buffer buffer) {
        if (buffer == null) {
            return;
        }
        if (!buffer.hasRemaining()) {
            buffer.clear();
        } else if (buffer.position() > 0) {
            buffer.compact();
        }
    }
}

