/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.TransformationException;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.Transformer;
import com.sun.grizzly.attributes.AttributeHolder;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.ssl.SSLResourcesAccessor;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLHandshakeDecoder
implements Transformer<Buffer, Buffer> {
    private Logger logger = Grizzly.logger;
    private TransformationResult<Buffer> lastResult;
    private Buffer input;
    private Buffer output;

    @Override
    public TransformationResult transform(AttributeStorage state) throws TransformationException {
        return this.transform(state, this.getInput(state), this.getOutput(state));
    }

    @Override
    public TransformationResult transform(AttributeStorage state, Buffer input, Buffer output) throws TransformationException {
        SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
        SSLEngine sslEngine = accessor.getSSLEngine(state);
        assert (sslEngine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        if (input == null) {
            input = this.getInput(state);
        }
        if (output == null) {
            output = this.getOutput(state);
        }
        SSLEngineResult result = null;
        do {
            try {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("SSLHandshakeDecoder engine: " + sslEngine + " input: " + input + " output: " + output);
                }
                result = sslEngine.unwrap((ByteBuffer)input.underlying(), (ByteBuffer)output.underlying());
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine("SSLHandshakeDecoder result: " + result + " engine: " + sslEngine + " input: " + input + " output: " + output);
            }
            catch (SSLException e) {
                throw new TransformationException(e);
            }
        } while (input.hasRemaining() && result.getStatus() == SSLEngineResult.Status.OK && result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        this.lastResult = new TransformationResult(TransformationResult.Status.COMPLETED, output.duplicate().flip());
        return this.lastResult;
    }

    @Override
    public Buffer getInput(AttributeStorage state) {
        if (this.input == null) {
            SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
            return accessor.obtainSecuredInBuffer(state);
        }
        return this.input;
    }

    @Override
    public void setInput(AttributeStorage state, Buffer input) {
        this.input = input;
    }

    @Override
    public Buffer getOutput(AttributeStorage state) {
        if (this.output == null) {
            SSLResourcesAccessor accessor = SSLResourcesAccessor.getInstance();
            return accessor.obtainAppBuffer(state);
        }
        return this.output;
    }

    @Override
    public void setOutput(AttributeStorage state, Buffer output) {
        this.output = output;
    }

    @Override
    public TransformationResult<Buffer> getLastResult(AttributeStorage state) {
        return this.lastResult;
    }

    @Override
    public AttributeHolder getProperties(AttributeStorage state) {
        return state.getAttributes();
    }

    @Override
    public void hibernate(AttributeStorage state) {
    }

    @Override
    public void release(AttributeStorage state) {
        this.lastResult = null;
        this.input = null;
        this.output = null;
    }
}

