/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.ssl;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Codec;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Transformer;
import com.sun.grizzly.ssl.BlockingSSLHandshaker;
import com.sun.grizzly.ssl.SSLContextConfigurator;
import com.sun.grizzly.ssl.SSLDecoderTransformer;
import com.sun.grizzly.ssl.SSLEncoderTransformer;
import com.sun.grizzly.ssl.SSLEngineConfigurator;
import com.sun.grizzly.ssl.SSLHandshaker;
import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

public class SSLCodec
implements Codec<Buffer, Buffer> {
    private SSLHandshaker sslHandshaker;
    private final SSLContext sslContext;
    private final SSLEngineConfigurator serverSSLEngineConfig;
    private final SSLEngineConfigurator clientSSLEngineConfig;
    private final Transformer<Buffer, Buffer> decoder;
    private final Transformer<Buffer, Buffer> encoder;

    public SSLCodec(SSLContextConfigurator config) {
        this(config.createSSLContext());
    }

    public SSLCodec(SSLContext sslContext) {
        this.sslContext = sslContext;
        this.decoder = new SSLDecoderTransformer();
        this.encoder = new SSLEncoderTransformer();
        this.serverSSLEngineConfig = new SSLEngineConfigurator(sslContext, false, false, false);
        this.clientSSLEngineConfig = new SSLEngineConfigurator(sslContext, true, false, false);
        this.sslHandshaker = new BlockingSSLHandshaker();
    }

    @Override
    public Transformer<Buffer, Buffer> getDecoder() {
        return this.decoder;
    }

    @Override
    public Transformer<Buffer, Buffer> getEncoder() {
        return this.encoder;
    }

    public SSLEngineConfigurator getClientSSLEngineConfig() {
        return this.clientSSLEngineConfig;
    }

    public SSLEngineConfigurator getServerSSLEngineConfig() {
        return this.serverSSLEngineConfig;
    }

    public SSLHandshaker getSslHandshaker() {
        return this.sslHandshaker;
    }

    public void setSslHandshaker(SSLHandshaker sslHandshaker) {
        this.sslHandshaker = sslHandshaker;
    }

    public Future<SSLEngine> handshake(Connection connection) throws IOException {
        return this.handshake(connection, this.clientSSLEngineConfig);
    }

    public Future<SSLEngine> handshake(Connection connection, SSLEngineConfigurator configurator) throws IOException {
        return null;
    }
}

