/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.smart.transformers;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.smart.SmartTransformer;
import com.sun.grizzly.smart.annotations.CharSequence;
import com.sun.grizzly.smart.transformers.SmartMemberTransformer;
import com.sun.grizzly.utils.StringDecoder;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.List;

public class SmartStringDecoder
extends StringDecoder
implements SmartMemberTransformer<Buffer, String> {
    protected Attribute<List> messageProcessingTreeAttribute;

    public SmartStringDecoder() {
        this((String)null);
    }

    public SmartStringDecoder(String stringTerminator) {
        this(Charset.forName("UTF-8"), stringTerminator);
    }

    public SmartStringDecoder(Charset charset) {
        this(charset, null);
    }

    public SmartStringDecoder(Charset charset, String stringTerminator) {
        super(charset, stringTerminator);
        this.messageProcessingTreeAttribute = this.attributeBuilder.createAttribute("SmartDecoderTransformer.processingTree");
    }

    @Override
    public void initialize(SmartTransformer parentTransformer, Field field) {
        CharSequence charSequenceAnn = field.getAnnotation(CharSequence.class);
        if (charSequenceAnn != null) {
            String terminateSeqAnn;
            String charsetAnn = charSequenceAnn.charset();
            if (!charsetAnn.equals(this.charset.name())) {
                this.charset = Charset.forName(charsetAnn);
            }
            if ((terminateSeqAnn = charSequenceAnn.terminate()) != null && terminateSeqAnn.length() > 0) {
                try {
                    this.stringTerminateBytes = terminateSeqAnn.getBytes(this.charset.name());
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public List getMessageProcessingTree(AttributeStorage storage) {
        return this.messageProcessingTreeAttribute.get(storage);
    }

    @Override
    public Object getCurrentMessageProcessingObject(AttributeStorage storage) {
        List messageProcessingTree = this.getMessageProcessingTree(storage);
        return messageProcessingTree.get(messageProcessingTree.size() - 1);
    }
}

