/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.smart.transformers;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.TransformationException;
import com.sun.grizzly.TransformationResult;
import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeStorage;
import com.sun.grizzly.memory.MemoryManager;
import com.sun.grizzly.smart.transformers.SequenceEncoder;
import java.lang.reflect.Array;

public class ArrayEncoder
extends SequenceEncoder<Object> {
    protected Attribute<Integer> currentElementIdxAttribute;

    public ArrayEncoder() {
        String prefix = ArrayEncoder.class.getName();
        this.currentElementIdxAttribute = this.attributeBuilder.createAttribute(prefix + ".currentElementIdx");
    }

    @Override
    public TransformationResult<Buffer> transform(AttributeStorage storage, Object input, Buffer output) throws TransformationException {
        if (input == null) {
            throw new TransformationException("Input should not be null");
        }
        if (this.componentType.isPrimitive() && this.componentType.equals(Byte.TYPE)) {
            MemoryManager memoryManager = null;
            if (output == null) {
                if (storage instanceof Connection) {
                    Connection connection = (Connection)storage;
                    memoryManager = connection.getTransport().getMemoryManager();
                    output = memoryManager.allocate(this.size(storage, input));
                } else {
                    throw new TransformationException("Output Buffer is null and there is no way to allocate one");
                }
            }
            int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, 0);
            int size = this.size(storage, input);
            int bytesToCopy = Math.min(output.remaining(), size - currentElementIdx);
            output.put((byte[])input, currentElementIdx, bytesToCopy);
            if ((currentElementIdx += bytesToCopy) < size) {
                this.saveState(storage, currentElementIdx, incompletedResult);
                return incompletedResult;
            }
            TransformationResult<Buffer> result = new TransformationResult<Buffer>(TransformationResult.Status.COMPLETED, output.duplicate().flip());
            this.saveState(storage, result);
            return result;
        }
        return super.transform(storage, input, output);
    }

    @Override
    public void release(AttributeStorage storage) {
        this.currentElementIdxAttribute.remove(storage);
        super.release(storage);
    }

    @Override
    protected Object get(AttributeStorage storage, Object sequence) {
        int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, -1);
        return Array.get(sequence, currentElementIdx);
    }

    @Override
    protected boolean previous(AttributeStorage storage, Object sequence) {
        int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, -1);
        if (currentElementIdx >= 0) {
            this.currentElementIdxAttribute.set(storage, (Integer)(--currentElementIdx));
            return true;
        }
        return false;
    }

    @Override
    protected boolean next(AttributeStorage storage, Object sequence) {
        int currentElementIdx = ArrayEncoder.getValue(storage, this.currentElementIdxAttribute, -1);
        if (currentElementIdx < Array.getLength(sequence)) {
            this.currentElementIdxAttribute.set(storage, (Integer)(++currentElementIdx));
            return true;
        }
        return false;
    }

    @Override
    protected int size(AttributeStorage storage, Object sequence) {
        return Array.getLength(sequence);
    }

    protected void saveState(AttributeStorage storage, int currentElementIdx, TransformationResult<Buffer> lastResult) {
        this.currentElementIdxAttribute.set(storage, (Integer)currentElementIdx);
        super.saveState(storage, lastResult);
    }
}

