/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.smart;

import com.sun.grizzly.Transformer;
import java.lang.reflect.Field;

public interface SequenceUnit {
    public Type getType();

    public static class StepOutUnit
    implements SequenceUnit {
        @Override
        public Type getType() {
            return Type.STEPOUT;
        }
    }

    public static class StepInUnit
    implements SequenceUnit {
        public Field field;

        public StepInUnit(Field field) {
            this.field = field;
        }

        @Override
        public Type getType() {
            return Type.STEPIN;
        }
    }

    public static class InstantiateUnit
    implements SequenceUnit {
        public Field field;

        public InstantiateUnit(Field field) {
            this.field = field;
        }

        @Override
        public Type getType() {
            return Type.INSTANTIATE;
        }
    }

    public static class TransformUnit
    implements SequenceUnit {
        public Transformer transformer;
        public Field field;

        public TransformUnit(Transformer transformer, Field field) {
            this.transformer = transformer;
            this.field = field;
        }

        @Override
        public Type getType() {
            return Type.TRANSFORM;
        }
    }

    public static enum Type {
        TRANSFORM,
        INSTANTIATE,
        STEPIN,
        STEPOUT;

    }
}

