/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.filterchain.FilterAdapter;
import com.sun.grizzly.filterchain.FilterChainContext;
import com.sun.grizzly.filterchain.NextAction;
import com.sun.grizzly.nio.transport.UDPNIOConnection;
import com.sun.grizzly.nio.transport.UDPNIOTransport;
import java.io.IOException;
import java.net.SocketAddress;

public class UDPNIOMessageTransportFilter
extends FilterAdapter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final UDPNIOTransport transport;

    UDPNIOMessageTransportFilter(UDPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        UDPNIOConnection connection = (UDPNIOConnection)ctx.getConnection();
        ReadResult readResult = new ReadResult(connection);
        this.transport.read(connection, null, readResult);
        if (readResult.getReadSize() > 0) {
            Buffer buffer = ((Buffer)readResult.getMessage()).flip();
            SocketAddress address = (SocketAddress)readResult.getSrcAddress();
            ctx.setMessage(buffer);
            ctx.setAddress(address);
            if (!connection.isConnected()) {
                ctx.getProcessorRunnable().setPostProcessor(null);
                connection.enableIOEvent(IOEvent.READ);
            }
        } else {
            return ctx.getStopAction();
        }
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        Object dstAddress = ctx.getAddress();
        if (message != null) {
            Connection connection = ctx.getConnection();
            this.transport.write(connection, (SocketAddress)dstAddress, (Buffer)message);
        }
        return nextAction;
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

