/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandler;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Interceptor;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.WriteResult;
import com.sun.grizzly.nio.AbstractNIOConnection;
import com.sun.grizzly.nio.SelectorRunner;
import com.sun.grizzly.nio.transport.UDPNIOStreamReader;
import com.sun.grizzly.nio.transport.UDPNIOStreamWriter;
import com.sun.grizzly.nio.transport.UDPNIOTransport;
import com.sun.grizzly.streams.AbstractStreamReader;
import com.sun.grizzly.streams.AbstractStreamWriter;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.streams.StreamWriter;
import com.sun.grizzly.utils.conditions.Condition;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UDPNIOConnection
extends AbstractNIOConnection {
    private Logger logger = Grizzly.logger;
    private final AbstractStreamReader streamReader;
    private final AbstractStreamWriter streamWriter;

    public UDPNIOConnection(UDPNIOTransport transport, DatagramChannel channel) {
        super(transport);
        this.channel = channel;
        this.setReadBufferSize(transport.getReadBufferSize());
        this.setWriteBufferSize(transport.getWriteBufferSize());
        this.streamReader = new UDPNIOStreamReader(this);
        this.streamWriter = new UDPNIOStreamWriter(this);
    }

    public boolean isConnected() {
        return this.channel != null && ((DatagramChannel)this.channel).isConnected();
    }

    public Future register() throws IOException {
        return this.transport.getNioChannelDistributor().registerChannelAsync(this.channel, 1, this, ((UDPNIOTransport)this.transport).registerChannelCompletionHandler);
    }

    @Override
    protected void setSelectionKey(SelectionKey selectionKey) {
        super.setSelectionKey(selectionKey);
    }

    @Override
    protected void setSelectorRunner(SelectorRunner selectorRunner) {
        super.setSelectorRunner(selectorRunner);
    }

    @Override
    public StreamReader getStreamReader() {
        return this.streamReader;
    }

    @Override
    public StreamWriter getStreamWriter() {
        return this.streamWriter;
    }

    @Override
    protected void preClose() {
        try {
            this.transport.fireIOEvent(IOEvent.CLOSED, this);
        }
        catch (IOException e) {
            Grizzly.logger.log(Level.FINE, "Unexpected IOExcption occurred, when firing CLOSE event");
        }
    }

    @Override
    public SocketAddress getPeerAddress() {
        if (this.channel != null) {
            return ((DatagramChannel)this.channel).socket().getRemoteSocketAddress();
        }
        return null;
    }

    @Override
    public SocketAddress getLocalAddress() {
        if (this.channel != null) {
            return ((DatagramChannel)this.channel).socket().getLocalSocketAddress();
        }
        return null;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        DatagramSocket socket = ((DatagramChannel)this.channel).socket();
        try {
            int socketReadBufferSize = socket.getReceiveBufferSize();
            if (readBufferSize != -1) {
                if (readBufferSize > socketReadBufferSize) {
                    socket.setReceiveBufferSize(readBufferSize);
                }
                super.setReadBufferSize(readBufferSize);
            } else {
                super.setReadBufferSize(socketReadBufferSize);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Error setting read buffer size", e);
        }
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        DatagramSocket socket = ((DatagramChannel)this.channel).socket();
        try {
            int socketWriteBufferSize = socket.getSendBufferSize();
            if (writeBufferSize != -1) {
                if (writeBufferSize > socketWriteBufferSize) {
                    socket.setSendBufferSize(writeBufferSize);
                }
                super.setWriteBufferSize(writeBufferSize);
            } else {
                super.setWriteBufferSize(socketWriteBufferSize);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Error setting write buffer size", e);
        }
    }

    @Override
    public Future<ReadResult<Buffer, SocketAddress>> read(Buffer buffer, CompletionHandler<ReadResult<Buffer, SocketAddress>> completionHandler, final Condition<ReadResult<Buffer, SocketAddress>> condition) throws IOException {
        UDPNIOTransport udpTransport = (UDPNIOTransport)this.transport;
        Interceptor<ReadResult<Buffer, SocketAddress>> interceptor = null;
        if (condition != null) {
            interceptor = new Interceptor<ReadResult<Buffer, SocketAddress>>(){

                @Override
                public int intercept(int event, Object context, ReadResult<Buffer, SocketAddress> result) {
                    if (event == 1) {
                        if (condition.check(result)) {
                            return 1;
                        }
                        return 2;
                    }
                    return 0;
                }
            };
        }
        if (this.isBlocking) {
            return udpTransport.getTemporarySelectorIO().getReader().read(this, buffer, completionHandler, (Interceptor<ReadResult>)interceptor);
        }
        return udpTransport.getAsyncQueueIO().getReader().read(this, buffer, completionHandler, (Interceptor<ReadResult>)interceptor);
    }

    @Override
    public Future<WriteResult<Buffer, SocketAddress>> write(SocketAddress dstAddress, Buffer buffer, CompletionHandler<WriteResult<Buffer, SocketAddress>> completionHandler) throws IOException {
        UDPNIOTransport udpTransport = (UDPNIOTransport)this.transport;
        if (this.isBlocking) {
            return udpTransport.getTemporarySelectorIO().getWriter().write((Connection)this, dstAddress, buffer, completionHandler);
        }
        return udpTransport.getAsyncQueueIO().getWriter().write((Connection)this, dstAddress, buffer, completionHandler);
    }
}

