/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.Connection;
import com.sun.grizzly.filterchain.FilterAdapter;
import com.sun.grizzly.filterchain.FilterChainContext;
import com.sun.grizzly.filterchain.NextAction;
import com.sun.grizzly.nio.transport.TCPNIOConnection;
import com.sun.grizzly.nio.transport.TCPNIOStreamReader;
import com.sun.grizzly.nio.transport.TCPNIOTransport;
import java.io.IOException;

public class TCPNIOTransportFilter
extends FilterAdapter {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final TCPNIOTransport transport;

    TCPNIOTransportFilter(TCPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        TCPNIOConnection connection = (TCPNIOConnection)ctx.getConnection();
        TCPNIOStreamReader reader = (TCPNIOStreamReader)connection.getStreamReader();
        Buffer buffer = reader.read0();
        reader.appendBuffer(buffer);
        if (!reader.hasAvailableData()) {
            return ctx.getStopAction();
        }
        ctx.setStreamReader(connection.getStreamReader());
        ctx.setStreamWriter(connection.getStreamWriter());
        return nextAction;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Object message = ctx.getMessage();
        if (message != null) {
            Connection connection = ctx.getConnection();
            connection.getStreamWriter().writeBuffer((Buffer)message);
        }
        return nextAction;
    }

    @Override
    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

