/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.Buffer;
import com.sun.grizzly.CompletionHandlerAdapter;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Context;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.PostProcessor;
import com.sun.grizzly.Processor;
import com.sun.grizzly.ProcessorExecutor;
import com.sun.grizzly.ProcessorResult;
import com.sun.grizzly.ProcessorRunnable;
import com.sun.grizzly.ProcessorSelector;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.SocketBinder;
import com.sun.grizzly.SocketConnectorHandler;
import com.sun.grizzly.Transport;
import com.sun.grizzly.WriteResult;
import com.sun.grizzly.asyncqueue.AsyncQueueEnabledTransport;
import com.sun.grizzly.asyncqueue.AsyncQueueIO;
import com.sun.grizzly.asyncqueue.AsyncQueueReader;
import com.sun.grizzly.asyncqueue.AsyncQueueWriter;
import com.sun.grizzly.filterchain.DefaultFilterChain;
import com.sun.grizzly.filterchain.Filter;
import com.sun.grizzly.filterchain.FilterChain;
import com.sun.grizzly.filterchain.FilterChainEnabledTransport;
import com.sun.grizzly.filterchain.FilterChainFactory;
import com.sun.grizzly.filterchain.PatternFilterChainFactory;
import com.sun.grizzly.filterchain.SingletonFilterChainFactory;
import com.sun.grizzly.nio.AbstractNIOTransport;
import com.sun.grizzly.nio.DefaultSelectionKeyHandler;
import com.sun.grizzly.nio.DefaultSelectorHandler;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.RegisterChannelResult;
import com.sun.grizzly.nio.RoundRobinConnectionDistributor;
import com.sun.grizzly.nio.SelectorRunner;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorIO;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorPool;
import com.sun.grizzly.nio.tmpselectors.TemporarySelectorsEnabledTransport;
import com.sun.grizzly.nio.transport.TCPNIOAsyncQueueReader;
import com.sun.grizzly.nio.transport.TCPNIOAsyncQueueWriter;
import com.sun.grizzly.nio.transport.TCPNIOConnection;
import com.sun.grizzly.nio.transport.TCPNIOConnectorHandler;
import com.sun.grizzly.nio.transport.TCPNIOServerConnection;
import com.sun.grizzly.nio.transport.TCPNIOTemporarySelectorReader;
import com.sun.grizzly.nio.transport.TCPNIOTemporarySelectorWriter;
import com.sun.grizzly.nio.transport.TCPNIOTransportFilter;
import com.sun.grizzly.strategies.WorkerThreadStrategy;
import com.sun.grizzly.threadpool.DefaultThreadPool;
import com.sun.grizzly.threadpool.ExtendedThreadPool;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPNIOTransport
extends AbstractNIOTransport
implements SocketBinder,
SocketConnectorHandler,
AsyncQueueEnabledTransport,
FilterChainEnabledTransport,
TemporarySelectorsEnabledTransport {
    private Logger logger = Grizzly.logger;
    private static final int DEFAULT_READ_BUFFER_SIZE = 65536;
    private static final int DEFAULT_WRITE_BUFFER_SIZE = 4096;
    private static final String DEFAULT_TRANSPORT_NAME = "TCPNIOTransport";
    private static final int DEFAULT_SELECTOR_RUNNERS_COUNT = 2;
    protected final Collection<TCPNIOServerConnection> serverConnections;
    protected FilterChainFactory filterChainFactory;
    protected AsyncQueueIO asyncQueueIO;
    protected TemporarySelectorIO temporarySelectorIO;
    protected int serverSocketSoTimeout = 0;
    protected boolean tcpNoDelay = true;
    protected boolean reuseAddress = true;
    protected int linger = -1;
    protected int clientSocketSoTimeout = -1;
    protected int connectionTimeout = 30000;
    private Filter defaultTransportFilter;
    protected final RegisterChannelCompletionHandler registerChannelCompletionHandler;
    private final EnableInterestPostProcessor enablingInterestPostProcessor;

    public TCPNIOTransport() {
        this(DEFAULT_TRANSPORT_NAME);
    }

    protected TCPNIOTransport(String name) {
        super(name);
        this.readBufferSize = 65536;
        this.writeBufferSize = 4096;
        this.registerChannelCompletionHandler = new RegisterChannelCompletionHandler();
        this.enablingInterestPostProcessor = new EnableInterestPostProcessor();
        this.asyncQueueIO = new AsyncQueueIO(new TCPNIOAsyncQueueReader(this), new TCPNIOAsyncQueueWriter(this));
        this.temporarySelectorIO = new TemporarySelectorIO(new TCPNIOTemporarySelectorReader(this), new TCPNIOTemporarySelectorWriter(this));
        SingletonFilterChainFactory patternFactory = new SingletonFilterChainFactory();
        DefaultFilterChain filterChain = new DefaultFilterChain(patternFactory);
        patternFactory.setFilterChainPattern(filterChain);
        this.filterChainFactory = patternFactory;
        this.defaultTransportFilter = new TCPNIOTransportFilter(this);
        this.serverConnections = new ConcurrentLinkedQueue<TCPNIOServerConnection>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            Transport.State currentState = (Transport.State)((Object)this.state.getState(false));
            if (currentState != Transport.State.STOP) {
                Grizzly.logger.log(Level.WARNING, "Transport is not in STOP or BOUND state!");
            }
            this.state.setState(Transport.State.STARTING);
            if (this.selectorHandler == null) {
                this.selectorHandler = new DefaultSelectorHandler();
            }
            if (this.selectionKeyHandler == null) {
                this.selectionKeyHandler = new DefaultSelectionKeyHandler();
            }
            if (this.processor == null && this.processorSelector == null) {
                this.processor = this.getFilterChainFactory().create();
            }
            if (this.selectorRunnersCount <= 0) {
                this.selectorRunnersCount = 2;
            }
            if (this.nioChannelDistributor == null) {
                this.nioChannelDistributor = new RoundRobinConnectionDistributor(this);
            }
            if (this.strategy == null) {
                this.strategy = new WorkerThreadStrategy(this);
            }
            if (this.internalThreadPool == null) {
                this.internalThreadPool = new DefaultThreadPool(this.selectorRunnersCount * 2, this.selectorRunnersCount * 4, 1, 5L, TimeUnit.SECONDS);
            }
            if (this.workerThreadPool == null) {
                this.workerThreadPool = new DefaultThreadPool();
            }
            int selectorPoolSize = 20;
            if (this.workerThreadPool instanceof ExtendedThreadPool) {
                selectorPoolSize = ((ExtendedThreadPool)((Object)this.workerThreadPool)).getMaximumPoolSize();
            }
            this.temporarySelectorIO.setSelectorPool(new TemporarySelectorPool(selectorPoolSize));
            this.startSelectorRunners();
            this.listenServerConnections();
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    private void listenServerConnections() {
        for (TCPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                serverConnection.listen();
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "Exception occurred when starting server connection: " + serverConnection, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            this.state.setState(Transport.State.STOP);
            this.stopSelectorRunners();
            if (this.internalThreadPool != null) {
                this.internalThreadPool.shutdown();
                this.internalThreadPool = null;
            }
            this.stopServerConnections();
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    private void stopServerConnections() {
        for (TCPNIOServerConnection serverConnection : this.serverConnections) {
            try {
                serverConnection.close();
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Exception occurred when closing server connection: " + serverConnection, e);
            }
        }
        this.serverConnections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (this.state.getState(false) != Transport.State.START) {
                Grizzly.logger.log(Level.WARNING, "Transport is not in START state!");
            }
            this.state.setState(Transport.State.PAUSE);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (this.state.getState(false) != Transport.State.PAUSE) {
                Grizzly.logger.log(Level.WARNING, "Transport is not in PAUSE state!");
            }
            this.state.setState(Transport.State.START);
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    @Override
    public TCPNIOServerConnection bind(int port) throws IOException {
        return this.bind(new InetSocketAddress(port));
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port) throws IOException {
        return this.bind(host, port, 50);
    }

    @Override
    public TCPNIOServerConnection bind(String host, int port, int backlog) throws IOException {
        return this.bind(new InetSocketAddress(host, port), backlog);
    }

    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress) throws IOException {
        return this.bind(socketAddress, 4096);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCPNIOServerConnection bind(SocketAddress socketAddress, int backlog) throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
            TCPNIOServerConnection serverConnection = new TCPNIOServerConnection(this, serverSocketChannel);
            this.serverConnections.add(serverConnection);
            ServerSocket serverSocket = serverSocketChannel.socket();
            serverSocket.setReuseAddress(this.reuseAddress);
            serverSocket.setSoTimeout(this.serverSocketSoTimeout);
            serverSocket.bind(socketAddress, backlog);
            serverSocketChannel.configureBlocking(false);
            if (!this.isStopped()) {
                serverConnection.listen();
            }
            TCPNIOServerConnection tCPNIOServerConnection = serverConnection;
            return tCPNIOServerConnection;
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(Connection connection) throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            if (connection != null && this.serverConnections.remove((TCPNIOServerConnection)connection)) {
                connection.close();
            }
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindAll() throws IOException {
        this.state.getStateLocker().writeLock().lock();
        try {
            this.stopServerConnections();
        }
        finally {
            this.state.getStateLocker().writeLock().unlock();
        }
    }

    @Override
    public Future<Connection> connect(String host, int port) throws IOException {
        return this.connect(new InetSocketAddress(host, port));
    }

    @Override
    public Future<Connection> connect(SocketAddress remoteAddress) throws IOException {
        return this.connect(remoteAddress, null);
    }

    @Override
    public Future<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        TCPNIOConnectorHandler connectorHandler = new TCPNIOConnectorHandler(this);
        return connectorHandler.connect(remoteAddress, localAddress);
    }

    @Override
    protected void closeConnection(Connection connection) throws IOException {
        SelectableChannel nioChannel = ((NIOConnection)connection).getChannel();
        if (nioChannel instanceof SocketChannel) {
            Socket socket = ((SocketChannel)nioChannel).socket();
            try {
                if (!socket.isInputShutdown()) {
                    socket.shutdownInput();
                }
            }
            catch (IOException e) {
                Grizzly.logger.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
            try {
                if (!socket.isOutputShutdown()) {
                    socket.shutdownOutput();
                }
            }
            catch (IOException e) {
                Grizzly.logger.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                Grizzly.logger.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (nioChannel != null) {
            try {
                nioChannel.close();
            }
            catch (IOException e) {
                Grizzly.logger.log(Level.FINE, "TCPNIOTransport.closeChannel exception", e);
            }
        }
        if (this.asyncQueueIO != null) {
            AsyncQueueWriter writer;
            AsyncQueueReader reader = this.asyncQueueIO.getReader();
            if (reader != null) {
                reader.onClose(connection);
            }
            if ((writer = this.asyncQueueIO.getWriter()) != null) {
                writer.onClose(connection);
            }
        }
    }

    protected NIOConnection obtainNIOConnection(SocketChannel channel) {
        TCPNIOConnection connection = new TCPNIOConnection(this, channel);
        connection.configureBlocking(this.isBlocking);
        return connection;
    }

    protected void configureChannel(SocketChannel channel) throws IOException {
        Socket socket = channel.socket();
        channel.configureBlocking(false);
        if (this.linger >= 0) {
            socket.setSoLinger(true, this.linger);
        }
        try {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        catch (IOException e) {
            this.logger.log(Level.WARNING, "Can not set TcpNoDelay to " + this.tcpNoDelay, e);
        }
        socket.setReuseAddress(this.reuseAddress);
    }

    @Override
    public AsyncQueueIO getAsyncQueueIO() {
        return this.asyncQueueIO;
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
    }

    public int getClientSocketSoTimeout() {
        return this.clientSocketSoTimeout;
    }

    public void setClientSocketSoTimeout(int socketTimeout) {
        this.clientSocketSoTimeout = socketTimeout;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public int getServerSocketSoTimeout() {
        return this.serverSocketSoTimeout;
    }

    public void setServerSocketSoTimeout(int serverSocketSoTimeout) {
        this.serverSocketSoTimeout = serverSocketSoTimeout;
    }

    @Override
    public FilterChainFactory getFilterChainFactory() {
        return this.filterChainFactory;
    }

    @Override
    public void setFilterChainFactory(FilterChainFactory factory) {
        this.filterChainFactory = factory;
    }

    @Override
    public FilterChain getFilterChain() {
        FilterChainFactory factory = this.getFilterChainFactory();
        if (factory instanceof PatternFilterChainFactory) {
            return ((PatternFilterChainFactory)factory).getFilterChainPattern();
        }
        throw new IllegalStateException("Transport FilterChainFactory doesn't support creating of FilterChain by a patterns. It means you have to add/remove Filters using FilterChainFactory API: " + factory.getClass().getName());
    }

    @Override
    public Filter getStreamTransportFilter() {
        return this.defaultTransportFilter;
    }

    @Override
    public Filter getMessageTransportFilter() {
        throw new UnsupportedOperationException("FilterChain 'message' mode is not supported for TCP NIO transport ");
    }

    @Override
    public TemporarySelectorIO getTemporarySelectorIO() {
        return this.temporarySelectorIO;
    }

    @Override
    public void setTemporarySelectorIO(TemporarySelectorIO temporarySelectorIO) {
        this.temporarySelectorIO = temporarySelectorIO;
    }

    @Override
    public void fireIOEvent(IOEvent ioEvent, Connection connection, Object strategyContext) throws IOException {
        try {
            if (ioEvent == IOEvent.READ) {
                this.processReadIoEvent(ioEvent, (TCPNIOConnection)connection, strategyContext);
            } else if (ioEvent == IOEvent.WRITE) {
                this.processWriteIoEvent(ioEvent, (TCPNIOConnection)connection, strategyContext);
            } else {
                if (ioEvent == IOEvent.SERVER_ACCEPT && ((TCPNIOServerConnection)connection).tryAccept()) {
                    return;
                }
                Processor conProcessor = this.getConnectionProcessor(connection, ioEvent);
                if (conProcessor != null) {
                    this.executeProcessor(ioEvent, connection, conProcessor, null, null, strategyContext);
                } else {
                    ((NIOConnection)connection).disableIOEvent(ioEvent);
                }
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException occurred on fireIOEvent().connection=" + connection + " event=" + (Object)((Object)ioEvent));
            throw e;
        }
        catch (Exception e) {
            String text = new StringBuilder(256).append("Unexpected exception occurred fireIOEvent().").append("connection=").append(connection).append(" event=").append((Object)ioEvent).toString();
            this.logger.log(Level.WARNING, text, e);
            throw new IOException(e.getClass() + ": " + text);
        }
    }

    protected void executeProcessor(IOEvent ioEvent, Connection connection, Processor processor, ProcessorExecutor executor, PostProcessor postProcessor, Object strategyContext) throws IOException {
        ProcessorRunnable processorRunnable = new ProcessorRunnable(ioEvent, connection, processor, postProcessor);
        this.strategy.executeProcessor(strategyContext, processorRunnable);
    }

    private void processReadIoEvent(IOEvent ioEvent, TCPNIOConnection connection, Object strategyContext) throws IOException {
        TCPNIOAsyncQueueReader asyncQueueReader = (TCPNIOAsyncQueueReader)this.getAsyncQueueIO().getReader();
        if (asyncQueueReader == null || !asyncQueueReader.isReady(connection)) {
            this.executeDefaultProcessor(ioEvent, connection, strategyContext);
        } else {
            connection.disableIOEvent(ioEvent);
            this.executeProcessor(ioEvent, connection, asyncQueueReader, null, null, strategyContext);
        }
    }

    private void processWriteIoEvent(IOEvent ioEvent, TCPNIOConnection connection, Object strategyContext) throws IOException {
        AsyncQueueWriter asyncQueueWriter = this.getAsyncQueueIO().getWriter();
        if (asyncQueueWriter == null || !asyncQueueWriter.isReady(connection)) {
            this.executeDefaultProcessor(ioEvent, connection, strategyContext);
        } else {
            connection.disableIOEvent(ioEvent);
            this.executeProcessor(ioEvent, connection, asyncQueueWriter, null, null, strategyContext);
        }
    }

    private void executeDefaultProcessor(IOEvent ioEvent, TCPNIOConnection connection, Object strategyContext) throws IOException {
        connection.disableIOEvent(ioEvent);
        Processor conProcessor = this.getConnectionProcessor(connection, ioEvent);
        if (conProcessor != null) {
            this.executeProcessor(ioEvent, connection, conProcessor, null, this.enablingInterestPostProcessor, strategyContext);
        }
    }

    Processor getConnectionProcessor(Connection connection, IOEvent ioEvent) {
        Processor conProcessor = connection.getProcessor();
        ProcessorSelector conProcessorSelector = connection.getProcessorSelector();
        if (!(conProcessor != null && conProcessor.isInterested(ioEvent) || conProcessorSelector == null)) {
            conProcessor = conProcessorSelector.select(ioEvent, connection);
        }
        return conProcessor;
    }

    public int read(Connection connection, Buffer buffer) throws IOException {
        return this.read(connection, buffer, null);
    }

    public int read(Connection connection, Buffer buffer, ReadResult currentResult) throws IOException {
        int read = 0;
        boolean isAllocated = false;
        if (buffer == null && currentResult != null) {
            buffer = this.memoryManager.allocate(connection.getReadBufferSize());
            isAllocated = true;
        }
        if (buffer.hasRemaining()) {
            TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
            read = ((ReadableByteChannel)((Object)tcpConnection.getChannel())).read((ByteBuffer)buffer.underlying());
        }
        if (isAllocated) {
            if (read > 0) {
                buffer.trim();
                buffer.position(buffer.limit());
            } else {
                buffer.dispose();
                buffer = null;
            }
        }
        if (currentResult != null && read >= 0) {
            currentResult.setMessage(buffer);
            currentResult.setReadSize(currentResult.getReadSize() + read);
            currentResult.setSrcAddress(connection.getPeerAddress());
        }
        return read;
    }

    public int write(Connection connection, Buffer buffer) throws IOException {
        return this.write(connection, buffer, null);
    }

    public int write(Connection connection, Buffer buffer, WriteResult currentResult) throws IOException {
        TCPNIOConnection tcpConnection = (TCPNIOConnection)connection;
        int written = ((WritableByteChannel)((Object)tcpConnection.getChannel())).write((ByteBuffer)buffer.underlying());
        if (currentResult != null) {
            currentResult.setMessage(buffer);
            currentResult.setWrittenSize(currentResult.getWrittenSize() + written);
            currentResult.setDstAddress(connection.getPeerAddress());
        }
        return written;
    }

    protected class RegisterChannelCompletionHandler
    extends CompletionHandlerAdapter<RegisterChannelResult> {
        protected RegisterChannelCompletionHandler() {
        }

        @Override
        public void completed(Connection c, RegisterChannelResult result) {
            try {
                SelectionKey selectionKey = result.getSelectionKey();
                TCPNIOConnection connection = (TCPNIOConnection)TCPNIOTransport.this.getSelectionKeyHandler().getConnectionForKey(selectionKey);
                if (connection != null) {
                    SelectorRunner selectorRunner = result.getSelectorRunner();
                    connection.setSelectionKey(selectionKey);
                    connection.setSelectorRunner(selectorRunner);
                    connection.resetAddresses();
                }
            }
            catch (Exception e) {
                Grizzly.logger.log(Level.FINE, "Exception happened, when trying to register the channel", e);
            }
        }
    }

    public class EnableInterestPostProcessor
    implements PostProcessor {
        public void process(ProcessorResult result, Context context) throws IOException {
            if (result == null || result.getStatus() == ProcessorResult.Status.OK) {
                IOEvent ioEvent = context.getIoEvent();
                ((NIOConnection)context.getConnection()).enableIOEvent(ioEvent);
            }
        }
    }
}

