/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio.transport;

import com.sun.grizzly.AbstractProcessor;
import com.sun.grizzly.CompletionHandlerAdapter;
import com.sun.grizzly.Connection;
import com.sun.grizzly.Context;
import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Processor;
import com.sun.grizzly.ProcessorResult;
import com.sun.grizzly.ProcessorSelector;
import com.sun.grizzly.StandaloneProcessorSelector;
import com.sun.grizzly.impl.FutureImpl;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.RegisterChannelResult;
import com.sun.grizzly.nio.SelectionKeyHandler;
import com.sun.grizzly.nio.transport.TCPNIOConnection;
import com.sun.grizzly.nio.transport.TCPNIOTransport;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Future;
import java.util.logging.Level;

public class TCPNIOServerConnection
extends TCPNIOConnection {
    private volatile FutureImpl acceptListener;
    private RegisterAcceptedChannelCompletionHandler defaultCompletionHandler = new RegisterAcceptedChannelCompletionHandler();
    private AcceptorEventProcessorSelector acceptorSelector = new AcceptorEventProcessorSelector();

    public TCPNIOServerConnection(TCPNIOTransport transport, ServerSocketChannel serverSocketChannel) {
        super(transport, serverSocketChannel);
    }

    public void listen() throws IOException {
        this.transport.getNioChannelDistributor().registerChannelAsync(this.channel, 16, this, ((TCPNIOTransport)this.transport).registerChannelCompletionHandler);
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.acceptorSelector;
    }

    public Future<Connection> accept() throws IOException {
        if (!this.isBlocking) {
            return this.acceptAsync();
        }
        Future<Connection> future = this.acceptAsync();
        try {
            future.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return future;
    }

    protected Future<Connection> acceptAsync() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is closed");
        }
        FutureImpl<Connection> future = new FutureImpl<Connection>();
        SocketChannel acceptedChannel = this.doAccept();
        if (acceptedChannel != null) {
            this.configureAcceptedChannel(acceptedChannel);
            this.registerAcceptedChannel(acceptedChannel, future);
        } else {
            this.acceptListener = future;
        }
        return future;
    }

    protected boolean tryAccept() throws IOException {
        if (this.acceptListener == null) {
            return false;
        }
        SocketChannel acceptedChannel = this.doAccept();
        if (acceptedChannel == null) {
            this.listen();
            return false;
        }
        this.configureAcceptedChannel(acceptedChannel);
        this.registerAcceptedChannel(acceptedChannel, this.acceptListener);
        this.acceptListener = null;
        return true;
    }

    private SocketChannel doAccept() throws IOException {
        ServerSocketChannel serverChannel = (ServerSocketChannel)this.getChannel();
        SocketChannel acceptedChannel = serverChannel.accept();
        return acceptedChannel;
    }

    private void configureAcceptedChannel(SocketChannel acceptedChannel) throws IOException {
        TCPNIOTransport tcpNIOTransport = (TCPNIOTransport)this.transport;
        tcpNIOTransport.configureChannel(acceptedChannel);
    }

    private void registerAcceptedChannel(SocketChannel acceptedChannel, FutureImpl listener) throws IOException {
        TCPNIOTransport tcpNIOTransport = (TCPNIOTransport)this.transport;
        NIOConnection connection = tcpNIOTransport.obtainNIOConnection(acceptedChannel);
        RegisterAcceptedChannelCompletionHandler handler = listener == null ? this.defaultCompletionHandler : new RegisterAcceptedChannelCompletionHandler(listener);
        connection.setProcessor(this.transport.getProcessor());
        connection.setProcessorSelector(this.transport.getProcessorSelector());
        tcpNIOTransport.getNioChannelDistributor().registerChannelAsync(acceptedChannel, 1, connection, handler);
    }

    @Override
    public void preClose() {
        if (this.acceptListener != null) {
            this.acceptListener.failure(new IOException("Connection is closed"));
        }
        try {
            ((TCPNIOTransport)this.transport).unbind(this);
        }
        catch (IOException e) {
            Grizzly.logger.log(Level.FINE, "Exception occurred, when unbind connection: " + this, e);
        }
        super.preClose();
    }

    protected void throwUnsupportReadWrite() {
        throw new UnsupportedOperationException("TCPNIOServerConnection doesn't support neither read nor write operations.");
    }

    protected class RegisterAcceptedChannelCompletionHandler
    extends CompletionHandlerAdapter<RegisterChannelResult> {
        private FutureImpl listener;

        public RegisterAcceptedChannelCompletionHandler() {
            this(null);
        }

        public RegisterAcceptedChannelCompletionHandler(FutureImpl listener) {
            this.listener = listener;
        }

        @Override
        public void completed(Connection c, RegisterChannelResult result) {
            try {
                TCPNIOTransport nioTransport = (TCPNIOTransport)TCPNIOServerConnection.this.transport;
                nioTransport.registerChannelCompletionHandler.completed(c, result);
                SelectionKeyHandler selectionKeyHandler = nioTransport.getSelectionKeyHandler();
                SelectionKey acceptedConnectionKey = result.getSelectionKey();
                NIOConnection connection = selectionKeyHandler.getConnectionForKey(acceptedConnectionKey);
                if (this.listener != null) {
                    this.listener.setResult(connection);
                }
                TCPNIOServerConnection.this.transport.fireIOEvent(IOEvent.ACCEPTED, connection);
            }
            catch (Exception e) {
                Grizzly.logger.log(Level.FINE, "Exception happened, when trying to accept the connection", e);
            }
        }
    }

    protected class AcceptorEventProcessor
    extends AbstractProcessor {
        protected AcceptorEventProcessor() {
        }

        @Override
        public ProcessorResult process(Context context) throws IOException {
            SocketChannel acceptedChannel = TCPNIOServerConnection.this.doAccept();
            if (acceptedChannel == null) {
                return null;
            }
            TCPNIOServerConnection.this.configureAcceptedChannel(acceptedChannel);
            TCPNIOServerConnection.this.registerAcceptedChannel(acceptedChannel, null);
            return null;
        }

        @Override
        public boolean isInterested(IOEvent ioEvent) {
            return true;
        }

        @Override
        public void setInterested(IOEvent ioEvent, boolean isInterested) {
        }
    }

    protected class AcceptorEventProcessorSelector
    implements ProcessorSelector {
        private AcceptorEventProcessor acceptorProcessor;

        protected AcceptorEventProcessorSelector() {
            this.acceptorProcessor = new AcceptorEventProcessor();
        }

        @Override
        public Processor select(IOEvent ioEvent, Connection connection) {
            if (ioEvent == IOEvent.SERVER_ACCEPT && !(TCPNIOServerConnection.this.transport.getProcessorSelector() instanceof StandaloneProcessorSelector)) {
                return this.acceptorProcessor;
            }
            return null;
        }
    }
}

