/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio;

import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.Strategy;
import com.sun.grizzly.Transport;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.NIOTransport;
import com.sun.grizzly.nio.SelectionKeyHandler;
import com.sun.grizzly.nio.SelectorHandler;
import com.sun.grizzly.utils.ExceptionHandler;
import com.sun.grizzly.utils.LinkedTransferQueue;
import com.sun.grizzly.utils.StateHolder;
import com.sun.grizzly.utils.conditions.ConditionListener;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectorRunner
implements Runnable {
    private static final Logger logger = Grizzly.logger;
    private final NIOTransport transport;
    private final StateHolder<Transport.State> stateHolder;
    private LinkedTransferQueue pendingOperations;
    private Selector selector;
    private Thread selectorRunnerThread;
    boolean isResume;
    SelectorHandler selectorHandler;
    SelectionKeyHandler selectionKeyHandler;
    Strategy strategy;
    int lastSelectedKeysCount;
    SelectionKey key = null;
    int keyEventProcessState;
    int keyReadyOps;
    Set<SelectionKey> readyKeys;
    Iterator<SelectionKey> iterator;

    public SelectorRunner(NIOTransport transport) {
        this(transport, null);
    }

    public SelectorRunner(NIOTransport transport, Selector selector) {
        this.transport = transport;
        this.selector = selector;
        this.stateHolder = new StateHolder<Transport.State>(false, Transport.State.STOP);
    }

    public NIOTransport getTransport() {
        return this.transport;
    }

    public Selector getSelector() {
        return this.selector;
    }

    public void setSelector(Selector selector) {
        this.selector = selector;
    }

    public Thread getRunnerThread() {
        return this.selectorRunnerThread;
    }

    public StateHolder<Transport.State> getStateHolder() {
        return this.stateHolder;
    }

    public Transport.State getState() {
        return this.stateHolder.getState();
    }

    public void postpone() {
        this.selectorRunnerThread = null;
        this.isResume = true;
    }

    public void start() {
        if (this.stateHolder.getState() != Transport.State.STOP) {
            Grizzly.logger.log(Level.WARNING, "SelectorRunner is not in the stopped state!");
        }
        this.pendingOperations = new LinkedTransferQueue();
        this.stateHolder.setState(Transport.State.STARTING);
        this.transport.getInternalThreadPool().execute(this);
    }

    public void startBlocking(int timeout) throws TimeoutException {
        this.start();
        SelectorRunner.waitUntilStateNotEqual(this.stateHolder, Transport.State.START, timeout);
    }

    public void stop() {
        this.stateHolder.setState(Transport.State.STOPPING);
        this.wakeupSelector();
        if (this.selector != null) {
            try {
                boolean isContinue = true;
                while (isContinue) {
                    try {
                        for (SelectionKey selectionKey : this.selector.keys()) {
                            NIOConnection connection = this.selectionKeyHandler.getConnectionForKey(selectionKey);
                            try {
                                connection.close();
                            }
                            catch (IOException e) {}
                        }
                        isContinue = false;
                    }
                    catch (ConcurrentModificationException concurrentModificationException) {}
                }
            }
            catch (ClosedSelectorException closedSelectorException) {
                // empty catch block
            }
        }
    }

    public void stopBlocking(int timeout) throws TimeoutException {
        this.stop();
        SelectorRunner.waitUntilStateNotEqual(this.stateHolder, Transport.State.STOP, timeout);
    }

    public void wakeupSelector() {
        if (this.selector != null) {
            this.selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.selectorRunnerThread = Thread.currentThread();
        if (!this.isResume) {
            this.selectorRunnerThread.setName(this.selectorRunnerThread.getName() + " SelectorRunner");
            this.stateHolder.setState(Transport.State.START);
        }
        StateHolder<Transport.State> transportStateHolder = this.transport.getState();
        boolean isSkipping = false;
        try {
            while (!isSkipping && !this.isStop(false)) {
                if (transportStateHolder.getState(false) != Transport.State.PAUSE) {
                    isSkipping = !this.doSelect();
                    continue;
                }
                try {
                    SelectorRunner.waitUntilStateEqual(transportStateHolder, Transport.State.PAUSE, 5000);
                }
                catch (TimeoutException timeoutException) {}
            }
        }
        finally {
            if (!isSkipping) {
                this.stateHolder.setState(Transport.State.STOP);
                this.selectorRunnerThread = null;
            }
        }
    }

    protected boolean doSelect() {
        this.selectorHandler = this.transport.getSelectorHandler();
        this.selectionKeyHandler = this.transport.getSelectionKeyHandler();
        this.strategy = this.transport.getStrategy();
        try {
            if (this.isResume) {
                this.isResume = false;
                if (this.keyReadyOps != 0 && !this.iterateKeyEvents()) {
                    return false;
                }
                if (!this.iterateKeys()) {
                    return false;
                }
            }
            this.lastSelectedKeysCount = 0;
            this.selectorHandler.preSelect(this);
            this.readyKeys = this.selectorHandler.select(this);
            if (this.stateHolder.getState(false) == Transport.State.STOPPING) {
                return false;
            }
            this.lastSelectedKeysCount = this.readyKeys.size();
            if (this.lastSelectedKeysCount != 0) {
                this.iterator = this.readyKeys.iterator();
                if (!this.iterateKeys()) {
                    return false;
                }
            }
            this.selectorHandler.postSelect(this);
        }
        catch (ClosedSelectorException e) {
            this.notifyConnectionException(this.key, "Selector was unexpectedly closed", e, ExceptionHandler.Severity.TRANSPORT, Level.SEVERE, Level.FINE);
        }
        catch (Exception e) {
            this.notifyConnectionException(this.key, "doSelect exception", e, ExceptionHandler.Severity.UNKNOWN, Level.SEVERE, Level.FINE);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "doSelect exception", t);
            this.transport.notifyException(ExceptionHandler.Severity.FATAL, t);
        }
        return true;
    }

    private boolean iterateKeys() {
        while (this.iterator.hasNext()) {
            try {
                this.key = this.iterator.next();
                this.iterator.remove();
                if (this.key.isValid()) {
                    this.keyEventProcessState = 0;
                    this.keyReadyOps = this.key.readyOps();
                    if (this.iterateKeyEvents()) continue;
                    return false;
                }
                this.selectionKeyHandler.cancel(this.key);
            }
            catch (IOException e) {
                this.keyEventProcessState = 0;
                this.keyReadyOps = 0;
                this.notifyConnectionException(this.key, "Unexpected IOException. Channel " + this.key.channel() + " will be closed.", e, ExceptionHandler.Severity.CONNECTION, Level.WARNING, Level.FINE);
            }
            catch (CancelledKeyException e) {
                this.keyEventProcessState = 0;
                this.keyReadyOps = 0;
                this.notifyConnectionException(this.key, "Unexpected CancelledKeyException. Channel " + this.key.channel() + " will be closed.", e, ExceptionHandler.Severity.CONNECTION, Level.WARNING, Level.FINE);
            }
        }
        return true;
    }

    private boolean iterateKeyEvents() throws IOException {
        boolean isRunningInSameThread = true;
        block6: while (this.keyReadyOps != 0 && isRunningInSameThread) {
            switch (this.keyEventProcessState) {
                case 0: {
                    int newReadyOps = this.keyReadyOps & 0xFFFFFFFE;
                    if (newReadyOps != this.keyReadyOps) {
                        this.keyReadyOps = newReadyOps;
                        if (this.selectionKeyHandler.onReadInterest(this.key)) {
                            isRunningInSameThread = this.fire(this.key, IOEvent.READ);
                        }
                        this.keyEventProcessState = 2;
                        continue block6;
                    }
                    ++this.keyEventProcessState;
                }
                case 1: {
                    int newReadyOps = this.keyReadyOps & 0xFFFFFFEF;
                    if (newReadyOps != this.keyReadyOps) {
                        this.keyReadyOps = newReadyOps;
                        if (!this.selectionKeyHandler.onAcceptInterest(this.key)) continue block6;
                        isRunningInSameThread = this.fire(this.key, IOEvent.SERVER_ACCEPT);
                        continue block6;
                    }
                    ++this.keyEventProcessState;
                }
                case 2: {
                    int newReadyOps = this.keyReadyOps & 0xFFFFFFFB;
                    if (newReadyOps != this.keyReadyOps) {
                        this.keyReadyOps = newReadyOps;
                        if (!this.selectionKeyHandler.onWriteInterest(this.key)) continue block6;
                        isRunningInSameThread = this.fire(this.key, IOEvent.WRITE);
                        continue block6;
                    }
                    ++this.keyEventProcessState;
                }
                case 3: {
                    int newReadyOps = this.keyReadyOps & 0xFFFFFFF7;
                    if (newReadyOps != this.keyReadyOps) {
                        this.keyReadyOps = newReadyOps;
                        if (!this.selectionKeyHandler.onConnectInterest(this.key)) continue block6;
                        isRunningInSameThread = this.fire(this.key, IOEvent.CONNECTED);
                        continue block6;
                    }
                    ++this.keyEventProcessState;
                    continue block6;
                }
            }
            throw new IllegalStateException("SelectorRunner SelectionKey=" + this.key + " readyOps=" + this.keyReadyOps + " state=" + this.keyEventProcessState);
        }
        return isRunningInSameThread;
    }

    private boolean fire(SelectionKey key, IOEvent ioEvent) throws IOException {
        NIOConnection connection = this.selectionKeyHandler.getConnectionForKey(key);
        Object context = this.strategy.prepare(connection, ioEvent);
        this.transport.fireIOEvent(ioEvent, connection, context);
        return !this.strategy.isTerminateThread(context);
    }

    public LinkedTransferQueue getPendingOperations() {
        return this.pendingOperations;
    }

    private boolean isStop(boolean isBlockingCompare) {
        Transport.State state = this.stateHolder.getState(isBlockingCompare);
        if (state == Transport.State.STOP || state == Transport.State.STOPPING) {
            return true;
        }
        state = this.transport.getState().getState(isBlockingCompare);
        return state == Transport.State.STOP || state == Transport.State.STOPPING;
    }

    private boolean isRunning(boolean isBlockingCompare) {
        return this.stateHolder.getState(isBlockingCompare) == Transport.State.START && this.transport.getState().getState(isBlockingCompare) == Transport.State.START;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitUntilStateNotEqual(StateHolder<Transport.State> stateHolder, Transport.State patternState, int timeout) throws TimeoutException {
        Object locker = new Object();
        ConditionListener<Transport.State, Object> listener = stateHolder.notifyWhenStateIsEqual(patternState, locker);
        if (listener != null) {
            Object object = locker;
            synchronized (object) {
                try {
                    if (stateHolder.getState(false) != patternState) {
                        locker.wait(timeout);
                    }
                }
                catch (InterruptedException e) {
                }
                finally {
                    stateHolder.removeConditionListener(listener);
                }
            }
        }
        if (stateHolder.getState(false) != patternState) {
            throw new TimeoutException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitUntilStateEqual(StateHolder<Transport.State> stateHolder, Transport.State patternState, int timeout) throws TimeoutException {
        Object locker = new Object();
        ConditionListener<Transport.State, Object> listener = stateHolder.notifyWhenStateIsNotEqual(patternState, locker);
        if (listener != null) {
            Object object = locker;
            synchronized (object) {
                try {
                    if (stateHolder.getState(false) == patternState) {
                        locker.wait(timeout);
                    }
                }
                catch (InterruptedException e) {
                }
                finally {
                    stateHolder.removeConditionListener(listener);
                }
            }
        }
        if (stateHolder.getState(false) == patternState) {
            throw new TimeoutException();
        }
    }

    private void notifyConnectionException(SelectionKey key, String description, Exception e, ExceptionHandler.Severity severity, Level runLogLevel, Level stoppedLogLevel) {
        if (this.isRunning(false)) {
            logger.log(runLogLevel, description, e);
            if (key != null) {
                try {
                    this.transport.getSelectionKeyHandler().cancel(key);
                }
                catch (IOException cancelException) {
                    logger.log(Level.FINE, "IOException during cancelling key", cancelException);
                }
            }
            this.transport.notifyException(severity, e);
        } else {
            logger.log(stoppedLogLevel, description, e);
        }
    }

    public int getLastSelectedKeysCount() {
        return this.lastSelectedKeysCount;
    }
}

