/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio;

import com.sun.grizzly.Grizzly;
import com.sun.grizzly.IOEvent;
import com.sun.grizzly.nio.NIOConnection;
import com.sun.grizzly.nio.SelectionKeyHandler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultSelectionKeyHandler
implements SelectionKeyHandler {
    private static Logger logger = Grizzly.logger;
    private static final int[] ioEvent2SelectionKeyInterest = new int[]{0, 16, 0, 8, 1, 4, 0};

    @Override
    public void onKeyRegistered(SelectionKey key) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "KEY IS REGISTERED: " + key);
        }
    }

    @Override
    public void cancel(SelectionKey key) throws IOException {
        key.cancel();
    }

    @Override
    public int ioEvent2SelectionKeyInterest(IOEvent ioEvent) {
        return ioEvent2SelectionKeyInterest[ioEvent.ordinal()];
    }

    @Override
    public IOEvent selectionKeyInterest2IoEvent(int selectionKeyInterest) {
        if ((selectionKeyInterest & 1) != 0) {
            return IOEvent.READ;
        }
        if ((selectionKeyInterest & 4) != 0) {
            return IOEvent.WRITE;
        }
        if ((selectionKeyInterest & 0x10) != 0) {
            return IOEvent.SERVER_ACCEPT;
        }
        if ((selectionKeyInterest & 8) != 0) {
            return IOEvent.CONNECTED;
        }
        return IOEvent.NONE;
    }

    @Override
    public boolean onAcceptInterest(SelectionKey key) throws IOException {
        return true;
    }

    @Override
    public boolean onConnectInterest(SelectionKey key) throws IOException {
        return true;
    }

    @Override
    public boolean onReadInterest(SelectionKey key) throws IOException {
        return true;
    }

    @Override
    public boolean onWriteInterest(SelectionKey key) throws IOException {
        return true;
    }

    @Override
    public NIOConnection getConnectionForKey(SelectionKey selectionKey) {
        return (NIOConnection)selectionKey.attachment();
    }

    @Override
    public void setConnectionForKey(NIOConnection connection, SelectionKey selectionKey) {
        selectionKey.attach(connection);
    }
}

