/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.nio;

import com.sun.grizzly.AbstractTransport;
import com.sun.grizzly.Connection;
import com.sun.grizzly.nio.NIOChannelDistributor;
import com.sun.grizzly.nio.NIOTransport;
import com.sun.grizzly.nio.SelectionKeyHandler;
import com.sun.grizzly.nio.SelectorFactory;
import com.sun.grizzly.nio.SelectorHandler;
import com.sun.grizzly.nio.SelectorRunner;
import java.io.IOException;
import java.nio.channels.Selector;

public abstract class AbstractNIOTransport
extends AbstractTransport
implements NIOTransport {
    protected SelectorHandler selectorHandler;
    protected SelectionKeyHandler selectionKeyHandler;
    protected int selectorRunnersCount;
    protected SelectorRunner[] selectorRunners;
    protected NIOChannelDistributor nioChannelDistributor;

    public AbstractNIOTransport(String name) {
        super(name);
    }

    @Override
    public SelectionKeyHandler getSelectionKeyHandler() {
        return this.selectionKeyHandler;
    }

    @Override
    public void setSelectionKeyHandler(SelectionKeyHandler selectionKeyHandler) {
        this.selectionKeyHandler = selectionKeyHandler;
    }

    @Override
    public SelectorHandler getSelectorHandler() {
        return this.selectorHandler;
    }

    @Override
    public void setSelectorHandler(SelectorHandler selectorHandler) {
        this.selectorHandler = selectorHandler;
    }

    @Override
    public int getSelectorRunnersCount() {
        return this.selectorRunnersCount;
    }

    @Override
    public void setSelectorRunnersCount(int selectorRunnersCount) {
        this.selectorRunnersCount = selectorRunnersCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSelectorRunners() throws IOException {
        SelectorRunner[] selectorRunnerArray = this.selectorRunners = new SelectorRunner[this.selectorRunnersCount];
        synchronized (this.selectorRunners) {
            for (int i = 0; i < this.selectorRunnersCount; ++i) {
                SelectorRunner runner = new SelectorRunner(this, SelectorFactory.instance().create());
                runner.start();
                this.selectorRunners[i] = runner;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSelectorRunners() throws IOException {
        if (this.selectorRunners == null) {
            return;
        }
        SelectorRunner[] selectorRunnerArray = this.selectorRunners;
        synchronized (this.selectorRunners) {
            for (int i = 0; i < this.selectorRunners.length; ++i) {
                SelectorRunner runner = this.selectorRunners[i];
                if (runner == null) continue;
                runner.stop();
                this.selectorRunners[i] = null;
                Selector selector = runner.getSelector();
                if (selector == null) continue;
                try {
                    selector.close();
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.selectorRunners = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public NIOChannelDistributor getNioChannelDistributor() {
        return this.nioChannelDistributor;
    }

    @Override
    public void setNioChannelDistributor(NIOChannelDistributor nioChannelDistributor) {
        this.nioChannelDistributor = nioChannelDistributor;
    }

    protected SelectorRunner[] getSelectorRunners() {
        return this.selectorRunners;
    }

    @Override
    protected abstract void closeConnection(Connection var1) throws IOException;
}

