/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filterchain;

import com.sun.grizzly.Connection;
import com.sun.grizzly.Transport;
import com.sun.grizzly.filterchain.Filter;
import com.sun.grizzly.filterchain.FilterAdapter;
import com.sun.grizzly.filterchain.FilterChainContext;
import com.sun.grizzly.filterchain.FilterChainEnabledTransport;
import com.sun.grizzly.filterchain.NextAction;
import java.io.IOException;

public class TransportFilter
extends FilterAdapter {
    public static final String WORKER_THREAD_BUFFER_NAME = "thread-buffer";
    private final Mode mode;

    public TransportFilter() {
        this(Mode.Stream);
    }

    public TransportFilter(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx, NextAction nextAction) throws IOException {
        TransportFilter.initializeContext(ctx);
        Filter transportFilter0 = this.getTransportFilter0(ctx.getConnection().getTransport());
        if (transportFilter0 != null) {
            ctx.setDefaultTransportFilter(transportFilter0);
            return transportFilter0.handleAccept(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction handleConnect(FilterChainContext ctx, NextAction nextAction) throws IOException {
        TransportFilter.initializeContext(ctx);
        Filter transportFilter0 = this.getTransportFilter0(ctx.getConnection().getTransport());
        if (transportFilter0 != null) {
            ctx.setDefaultTransportFilter(transportFilter0);
            return transportFilter0.handleConnect(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        TransportFilter.initializeContext(ctx);
        Filter transportFilter0 = this.getTransportFilter0(ctx.getConnection().getTransport());
        if (transportFilter0 != null) {
            ctx.setDefaultTransportFilter(transportFilter0);
            return transportFilter0.handleRead(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction handleWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        TransportFilter.initializeContext(ctx);
        Filter transportFilter0 = this.getTransportFilter0(ctx.getConnection().getTransport());
        if (transportFilter0 != null) {
            ctx.setDefaultTransportFilter(transportFilter0);
            return transportFilter0.handleWrite(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction handleClose(FilterChainContext ctx, NextAction nextAction) throws IOException {
        TransportFilter.initializeContext(ctx);
        Filter transportFilter0 = this.getTransportFilter0(ctx.getConnection().getTransport());
        if (transportFilter0 != null) {
            ctx.setDefaultTransportFilter(transportFilter0);
            return transportFilter0.handleClose(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction postAccept(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Filter transportFilter0 = ctx.getDefaultTransportFilter();
        if (transportFilter0 != null) {
            return transportFilter0.postAccept(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction postConnect(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Filter transportFilter0 = ctx.getDefaultTransportFilter();
        if (transportFilter0 != null) {
            return transportFilter0.postRead(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction postRead(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Filter transportFilter0 = ctx.getDefaultTransportFilter();
        if (transportFilter0 != null) {
            return transportFilter0.postConnect(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction postWrite(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Filter transportFilter0 = ctx.getDefaultTransportFilter();
        if (transportFilter0 != null) {
            return transportFilter0.postWrite(ctx, nextAction);
        }
        return null;
    }

    @Override
    public NextAction postClose(FilterChainContext ctx, NextAction nextAction) throws IOException {
        Filter transportFilter0 = ctx.getDefaultTransportFilter();
        if (transportFilter0 != null) {
            return transportFilter0.postClose(ctx, nextAction);
        }
        return null;
    }

    protected Filter getTransportFilter0(Transport transport) {
        if (transport instanceof FilterChainEnabledTransport) {
            if (this.mode == Mode.Stream) {
                return ((FilterChainEnabledTransport)((Object)transport)).getStreamTransportFilter();
            }
            return ((FilterChainEnabledTransport)((Object)transport)).getMessageTransportFilter();
        }
        return null;
    }

    private static final void initializeContext(FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        ctx.setStreamReader(connection.getStreamReader());
        ctx.setStreamWriter(connection.getStreamWriter());
    }

    public static enum Mode {
        Stream,
        Message;

    }
}

