/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.filterchain;

import com.sun.grizzly.Context;
import com.sun.grizzly.filterchain.Filter;
import com.sun.grizzly.filterchain.FilterChain;
import com.sun.grizzly.filterchain.InvokeAction;
import com.sun.grizzly.filterchain.NextAction;
import com.sun.grizzly.filterchain.RerunChainAction;
import com.sun.grizzly.filterchain.StopAction;
import com.sun.grizzly.filterchain.SuspendAction;
import com.sun.grizzly.streams.StreamReader;
import com.sun.grizzly.streams.StreamWriter;
import com.sun.grizzly.utils.LightArrayList;
import com.sun.grizzly.utils.MessageHolder;
import com.sun.grizzly.utils.ObjectPool;
import java.util.ArrayList;
import java.util.List;

public class FilterChainContext
extends Context {
    private static final NextAction INVOKE_ACTION = new InvokeAction();
    private static final NextAction RERUN_CHAIN_ACTION = new RerunChainAction();
    private static final NextAction STOP_ACTION = new StopAction();
    private static final NextAction SUSPEND_ACTION = new SuspendAction();
    private InvokeAction cachedInvokeAction;
    private Filter currentFilter;
    private MessageHolder messageHolder = new MessageHolder();
    private StreamReader streamReader;
    private StreamWriter streamWriter;
    private List<Filter> executedFilters = new LightArrayList<Filter>();
    private int currentFilterIdx = 0;
    private List<Filter> filters;
    private Filter defaultTransportFilter;

    public FilterChainContext(ObjectPool parentPool) {
        super(parentPool);
    }

    public List<Filter> getExecutedFilters() {
        return this.executedFilters;
    }

    protected void setExecutedFilters(List<Filter> executedFilters) {
        this.executedFilters = executedFilters;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public int getCurrentFilterIdx() {
        return this.currentFilterIdx;
    }

    public void setCurrentFilterIdx(int currentFilterIdx) {
        this.currentFilterIdx = currentFilterIdx;
    }

    public FilterChain getFilterChain() {
        return (FilterChain)this.getProcessor();
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    protected void setCurrentFilter(Filter currentFilter) {
        this.currentFilter = currentFilter;
    }

    public Object getMessage() {
        return this.messageHolder.getMessage();
    }

    public void setMessage(Object message) {
        this.messageHolder.setMessage(message);
    }

    public Object getAddress() {
        return this.messageHolder.getAddress();
    }

    public void setAddress(Object address) {
        this.messageHolder.setAddress(address);
    }

    public StreamReader getStreamReader() {
        return this.streamReader;
    }

    public void setStreamReader(StreamReader streamReader) {
        this.streamReader = streamReader;
    }

    public StreamWriter getStreamWriter() {
        return this.streamWriter;
    }

    public void setStreamWriter(StreamWriter streamWriter) {
        this.streamWriter = streamWriter;
    }

    public NextAction getInvokeAction() {
        return INVOKE_ACTION;
    }

    public NextAction getInvokeAction(List<Filter> filters) {
        return new InvokeAction(new ArrayList<Filter>(filters));
    }

    public NextAction getInvokeAction(List<Filter> filters, int nextFilterIdx) {
        return new InvokeAction(new ArrayList<Filter>(filters), nextFilterIdx);
    }

    public NextAction getRerunChainAction() {
        return RERUN_CHAIN_ACTION;
    }

    public NextAction getStopAction() {
        return STOP_ACTION;
    }

    public NextAction getSuspendAction() {
        return SUSPEND_ACTION;
    }

    Filter getDefaultTransportFilter() {
        return this.defaultTransportFilter;
    }

    void setDefaultTransportFilter(Filter defaultTransportFilter) {
        this.defaultTransportFilter = defaultTransportFilter;
    }

    final InvokeAction getCachedInvokeAction() {
        return this.cachedInvokeAction;
    }

    final void setCachedInvokeAction(InvokeAction cachedInvokeAction) {
        this.cachedInvokeAction = cachedInvokeAction;
    }

    @Override
    public void release() {
        this.currentFilter = null;
        this.messageHolder.setAddress(null);
        this.messageHolder.setMessage(null);
        this.streamReader = null;
        this.streamWriter = null;
        this.filters = null;
        this.executedFilters.clear();
        this.defaultTransportFilter = null;
        super.release();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(384);
        sb.append("FilterChainContext [");
        sb.append("connection=").append(this.getConnection());
        sb.append(", message=").append(this.getMessage());
        sb.append(", address=").append(this.getAddress());
        sb.append(", executedFilters=").append(this.executedFilters);
        sb.append(']');
        return sb.toString();
    }
}

