/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.attributes;

import com.sun.grizzly.attributes.Attribute;
import com.sun.grizzly.attributes.AttributeBuilder;
import com.sun.grizzly.attributes.NullaryFunction;
import com.sun.grizzly.utils.LightArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DefaultAttributeBuilder
implements AttributeBuilder {
    protected List<Attribute> attributes = new LightArrayList<Attribute>();
    protected Map<String, Attribute> name2Attribute = new HashMap<String, Attribute>();

    protected static void setAttributeIndex(Attribute attribute, int index) {
        attribute.setIndex(index);
    }

    @Override
    public synchronized <T> Attribute<T> createAttribute(String name) {
        return this.createAttribute(name, (Object)null);
    }

    @Override
    public synchronized <T> Attribute<T> createAttribute(String name, T defaultValue) {
        Attribute<T> attribute = this.name2Attribute.get(name);
        if (attribute == null) {
            attribute = new Attribute<T>((AttributeBuilder)this, name, defaultValue);
            attribute.setIndex(this.attributes.size());
            this.attributes.add(attribute);
            this.name2Attribute.put(name, attribute);
        }
        return attribute;
    }

    @Override
    public synchronized <T> Attribute<T> createAttribute(String name, NullaryFunction<T> initializer) {
        Attribute<T> attribute = this.name2Attribute.get(name);
        if (attribute == null) {
            attribute = new Attribute<T>((AttributeBuilder)this, name, initializer);
            attribute.setIndex(this.attributes.size());
            this.attributes.add(attribute);
            this.name2Attribute.put(name, attribute);
        }
        return attribute;
    }

    protected Attribute getAttributeByName(String name) {
        return this.name2Attribute.get(name);
    }

    protected Attribute getAttributeByIndex(int index) {
        return this.attributes.get(index);
    }
}

