/*
 * 
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2007-2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 */

package com.sun.grizzly.nio.transport;

import java.net.SocketAddress;
import com.sun.grizzly.Connection;
import com.sun.grizzly.filterchain.FilterAdapter;
import com.sun.grizzly.filterchain.FilterChainContext;
import com.sun.grizzly.filterchain.NextAction;
import java.io.IOException;
import java.util.logging.Filter;
import com.sun.grizzly.Buffer;
import com.sun.grizzly.ReadResult;
import com.sun.grizzly.streams.AddressableStreamWriter;

/**
 * The {@link UDPNIOTransport}'s transport {@link Filter} implementation
 * 
 * @author Alexey Stashok
 */
public class UDPNIOStreamTransportFilter extends FilterAdapter {

    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private final UDPNIOTransport transport;

    UDPNIOStreamTransportFilter(final UDPNIOTransport transport) {
        this.transport = transport;
    }

    @Override
    public NextAction handleRead(final FilterChainContext ctx,
            final NextAction nextAction) throws IOException {
        final UDPNIOConnection connection = (UDPNIOConnection) ctx.getConnection();

        final UDPNIOStreamReader reader =
                (UDPNIOStreamReader) connection.getStreamReader();
        final ReadResult<Buffer, SocketAddress> result = reader.read0();
        reader.append(result);

        if (reader.hasAvailableData()) {
            ctx.setStreamReader(connection.getStreamReader());
            ctx.setStreamWriter(connection.getStreamWriter());
        } else {
            return ctx.getStopAction();
        }

        return nextAction;
    }

    @Override
    public NextAction handleWrite(final FilterChainContext ctx,
            final NextAction nextAction) throws IOException {
        final Object message = ctx.getMessage();
        final Object dstAddress = ctx.getAddress();
        if (message != null) {
            UDPNIOConnection connection = (UDPNIOConnection) ctx.getConnection();
            AddressableStreamWriter<SocketAddress> writer =
                    (AddressableStreamWriter<SocketAddress>) connection.getStreamWriter();
            if (!connection.isConnected()) {
                writer.setPeerAddress((SocketAddress) dstAddress);
            }
            
            writer.writeBuffer((Buffer) message);
            writer.flush();
        }

        return nextAction;
    }

    @Override
    public void exceptionOccurred(final FilterChainContext ctx,
            final Throwable error) {

        final Connection connection = ctx.getConnection();
        if (connection != null) {
            try {
                connection.close();
            } catch (IOException e) {
            }
        }
    }
}
