/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.view;

import java.util.ArrayList;
import java.util.List;

public enum PaperSize {
    A6_Portrait("A6", Orientation.Portrait, 1240, 1748),
    A6_Landscape("A6", Orientation.Landscape, 1748, 1240),
    A5_Portrait("A5", Orientation.Portrait, 1748, 2480),
    A5_Landscape("A5", Orientation.Landscape, 2480, 1748),
    A4_Portrait("A4", Orientation.Portrait, 2480, 3508),
    A4_Landscape("A4", Orientation.Landscape, 3508, 2480),
    A3_Portrait("A3", Orientation.Portrait, 3508, 4961),
    A3_Landscape("A3", Orientation.Landscape, 4961, 3508),
    A2_Portrait("A2", Orientation.Portrait, 4961, 7016),
    A2_Landscape("A2", Orientation.Landscape, 7016, 4961),
    A1_Portrait("A1", Orientation.Portrait, 7016, 9933),
    A1_Landscape("A1", Orientation.Landscape, 9933, 7016),
    A0_Portrait("A0", Orientation.Portrait, 9933, 14043),
    A0_Landscape("A0", Orientation.Landscape, 14043, 9933),
    Letter_Portrait("Letter", Orientation.Portrait, 2550, 3300),
    Letter_Landscape("Letter", Orientation.Landscape, 3300, 2550),
    Legal_Portrait("Legal", Orientation.Portrait, 2550, 4200),
    Legal_Landscape("Legal", Orientation.Landscape, 4200, 2550),
    Slide_4_3("Slide 4:3", Orientation.Landscape, 3306, 2480),
    Slide_16_9("Slide 16:9", Orientation.Landscape, 3508, 1973),
    Slide_16_10("Slide 16:10", Orientation.Landscape, 3508, 2193);

    private String name;
    private Orientation orientation;
    private int width;
    private int height;

    private PaperSize(String name, Orientation orientation, int width, int height) {
        this.name = name;
        this.orientation = orientation;
        this.width = width;
        this.height = height;
    }

    public String getName() {
        return this.name;
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static List<PaperSize> getOrderedPaperSizes() {
        ArrayList<PaperSize> paperSizes = new ArrayList<PaperSize>();
        paperSizes.addAll(PaperSize.getOrderedPaperSizes(Orientation.Landscape));
        paperSizes.addAll(PaperSize.getOrderedPaperSizes(Orientation.Portrait));
        return paperSizes;
    }

    public static List<PaperSize> getOrderedPaperSizes(Orientation orientation) {
        ArrayList<PaperSize> paperSizes = new ArrayList<PaperSize>();
        for (PaperSize paperSize : PaperSize.values()) {
            if (paperSize.getOrientation() != orientation) continue;
            paperSizes.add(paperSize);
        }
        return paperSizes;
    }

    public static enum Orientation {
        Portrait,
        Landscape;

    }
}

