/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress.util;

import java.nio.ByteBuffer;
import java.util.UUID;

public abstract class UuidConverter {
    private static final char[] C64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_".toCharArray();
    private static final int[] I256 = new int[256];

    public static String format(UUID uuid) {
        if (uuid == null) {
            throw new NullPointerException("Null UUID");
        }
        byte[] bytes = UuidConverter.toByteArray(uuid);
        return UuidConverter.encodeBase64(bytes);
    }

    public static UUID parse(String uuidString) {
        if (uuidString == null) {
            throw new NullPointerException("Null UUID string");
        }
        if (uuidString.length() > 24) {
            return UUID.fromString(uuidString);
        }
        if (uuidString.length() < 22) {
            throw new IllegalArgumentException("Short UUID must be 22 characters: " + uuidString);
        }
        byte[] bytes = UuidConverter.decodeBase64(uuidString);
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.put(bytes, 0, 16);
        bb.clear();
        return new UUID(bb.getLong(), bb.getLong());
    }

    private static byte[] toByteArray(UUID uuid) {
        ByteBuffer bb = ByteBuffer.wrap(new byte[16]);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        return bb.array();
    }

    private static String encodeBase64(byte[] bytes) {
        int d;
        if (bytes == null) {
            throw new NullPointerException("Null UUID byte array");
        }
        if (bytes.length != 16) {
            throw new IllegalArgumentException("UUID must be 16 bytes");
        }
        char[] chars = new char[22];
        int i = 0;
        int j = 0;
        while (i < 15) {
            d = (bytes[i++] & 0xFF) << 16 | (bytes[i++] & 0xFF) << 8 | bytes[i++] & 0xFF;
            chars[j++] = C64[d >>> 18 & 0x3F];
            chars[j++] = C64[d >>> 12 & 0x3F];
            chars[j++] = C64[d >>> 6 & 0x3F];
            chars[j++] = C64[d & 0x3F];
        }
        d = (bytes[i] & 0xFF) << 10;
        chars[j++] = C64[d >> 12];
        chars[j++] = C64[d >>> 6 & 0x3F];
        return new String(chars);
    }

    private static byte[] decodeBase64(String s) {
        if (s == null) {
            throw new NullPointerException("Cannot decode null string");
        }
        if (s.isEmpty() || s.length() > 24) {
            throw new IllegalArgumentException("Invalid short UUID");
        }
        byte[] bytes = new byte[16];
        int i = 0;
        int j = 0;
        while (i < 15) {
            int d = I256[s.charAt(j++)] << 18 | I256[s.charAt(j++)] << 12 | I256[s.charAt(j++)] << 6 | I256[s.charAt(j++)];
            bytes[i++] = (byte)(d >> 16);
            bytes[i++] = (byte)(d >> 8);
            bytes[i++] = (byte)d;
        }
        bytes[i] = (byte)((I256[s.charAt(j++)] << 18 | I256[s.charAt(j++)] << 12) >> 16);
        return bytes;
    }

    static {
        for (int i = 0; i < C64.length; ++i) {
            UuidConverter.I256[UuidConverter.C64[i]] = i;
        }
    }
}

