/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress.util;

import com.strategicgains.repoexpress.adapter.Identifiers;
import com.strategicgains.repoexpress.domain.Identifier;
import com.strategicgains.repoexpress.util.UuidConverter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;

public abstract class Format {
    public static String uuid(UUID uuid) {
        return UuidConverter.format(uuid);
    }

    public static String id(Identifier id) {
        return Identifiers.UUID.format(id);
    }

    public static String intId(Identifier id) {
        return Identifiers.INTEGER.format(id);
    }

    public static String longId(Identifier id) {
        return Identifiers.LONG.format(id);
    }

    public static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    public static void useShortUUID() {
        Identifiers.useShortUUID();
    }
}

