/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress.memory;

import com.strategicgains.repoexpress.AbstractObservableRepository;
import com.strategicgains.repoexpress.domain.Identifiable;
import com.strategicgains.repoexpress.domain.Identifier;
import com.strategicgains.repoexpress.exception.DuplicateItemException;
import com.strategicgains.repoexpress.exception.ItemNotFoundException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class InMemoryRepository<T extends Identifiable>
extends AbstractObservableRepository<T> {
    private static long nextId = 0L;
    protected Map<Identifier, T> items = new ConcurrentHashMap<Identifier, T>();

    @Override
    public boolean exists(Identifier id) {
        return this.items.containsKey(id);
    }

    @Override
    public T doCreate(T item) {
        if (this.hasId(item)) {
            try {
                this.read(item.getId());
                throw new DuplicateItemException(item.getClass().getSimpleName() + " ID already exists: " + item.getId().toString());
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        } else {
            item.setId(new Identifier(item.getClass().getSimpleName(), ++nextId));
        }
        this.items.put(item.getId(), item);
        return item;
    }

    @Override
    public T doRead(Identifier id) {
        Identifiable b = (Identifiable)this.items.get(id);
        if (b == null) {
            throw new ItemNotFoundException("ID not found: " + id.toString());
        }
        return (T)b;
    }

    @Override
    public T doUpdate(T item) {
        this.items.put(item.getId(), item);
        return item;
    }

    @Override
    public void doDelete(T object) {
        Identifiable item = (Identifiable)this.items.remove(object.getId());
        if (item == null) {
            throw new ItemNotFoundException("ID not found: " + object.getId().toString());
        }
    }
}

