/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress;

import com.strategicgains.repoexpress.Repository;
import com.strategicgains.repoexpress.domain.Identifiable;
import com.strategicgains.repoexpress.domain.Identifier;
import com.strategicgains.repoexpress.exception.ItemNotFoundException;
import com.strategicgains.repoexpress.exception.RepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractRepository<T extends Identifiable>
implements Repository<T> {
    @Override
    public void delete(Identifier id) {
        Object object = this.read(id);
        this.delete(object);
    }

    @Override
    public List<T> readList(Collection<Identifier> ids) {
        ArrayList results = new ArrayList(ids.size());
        for (Identifier id : ids) {
            try {
                results.add(this.read(id));
            }
            catch (RepositoryException repositoryException) {}
        }
        return results;
    }

    @Override
    public boolean exists(Identifier id) {
        try {
            return this.read(id) != null;
        }
        catch (ItemNotFoundException e) {
            return false;
        }
    }

    protected boolean hasId(T item) {
        return item.getId() != null && !item.getId().isEmpty();
    }
}

