/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.repoexpress;

import com.strategicgains.repoexpress.AbstractRepository;
import com.strategicgains.repoexpress.ObservableRepository;
import com.strategicgains.repoexpress.domain.Identifiable;
import com.strategicgains.repoexpress.domain.Identifier;
import com.strategicgains.repoexpress.event.RepositoryObserver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractObservableRepository<T extends Identifiable>
extends AbstractRepository<T>
implements ObservableRepository<T> {
    private List<RepositoryObserver<T>> observers = new ArrayList<RepositoryObserver<T>>();

    @Override
    public void addObserver(RepositoryObserver<T> observer) {
        this.getObserversInternal().add(observer);
    }

    @Override
    public void clearObservers() {
        this.getObserversInternal().clear();
    }

    private List<RepositoryObserver<T>> getObserversInternal() {
        return this.observers;
    }

    @Override
    public List<RepositoryObserver<T>> getObservers() {
        return Collections.unmodifiableList(this.getObserversInternal());
    }

    @Override
    public boolean removeObserver(RepositoryObserver<T> observer) {
        return this.getObserversInternal().remove(observer);
    }

    @Override
    public final T create(T object) {
        this.notifyBeforeCreate(object);
        T created = this.doCreate(object);
        this.notifyAfterCreate(created);
        return created;
    }

    @Override
    public final void delete(T object) {
        this.notifyBeforeDelete(object);
        this.doDelete(object);
        this.notifyAfterDelete(object);
    }

    @Override
    public final T read(Identifier id) {
        this.notifyBeforeRead(id);
        Object result = this.doRead(id);
        this.notifyAfterRead(result);
        return result;
    }

    @Override
    public final T update(T object) {
        this.notifyBeforeUpdate(object);
        T result = this.doUpdate(object);
        this.notifyAfterUpdate(object);
        return result;
    }

    protected void notifyAfterCreate(T object) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.afterCreate(object);
        }
    }

    protected void notifyAfterDelete(T object) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.afterDelete(object);
        }
    }

    protected void notifyAfterRead(T object) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.afterRead(object);
        }
    }

    protected void notifyAfterUpdate(T object) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.afterUpdate(object);
        }
    }

    protected void notifyBeforeCreate(T object) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.beforeCreate(object);
        }
    }

    protected void notifyBeforeDelete(T object) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.beforeDelete(object);
        }
    }

    protected void notifyBeforeRead(Identifier id) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.beforeRead(id);
        }
    }

    protected void notifyBeforeUpdate(T object) {
        for (RepositoryObserver<T> observer : this.getObserversInternal()) {
            observer.beforeUpdate(object);
        }
    }

    protected class PrimaryIdIterator
    implements Iterator<Object> {
        private Iterator<Identifier> iterator;

        public PrimaryIdIterator(Iterator<Identifier> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return this.iterator.next().primaryKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    protected class PrimaryIdIterable
    implements Iterable<Object> {
        private Iterable<Identifier> iterable;

        public PrimaryIdIterable(Iterable<Identifier> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<Object> iterator() {
            return new PrimaryIdIterator(this.iterable.iterator());
        }
    }
}

