/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.swagger.utilities;

import java.math.BigDecimal;
import java.util.Date;

public class SwaggerObjectConverter {
    public static <T> T convertObjectTo(Object object, Class<T> explicitType) {
        Object returnObject;
        if (object == null) {
            returnObject = null;
        } else if (!object.getClass().isAssignableFrom(explicitType)) {
            String toString = object.toString();
            if (explicitType.isAssignableFrom(Integer.class) || explicitType.isAssignableFrom(Integer.TYPE)) {
                returnObject = Integer.parseInt(toString);
            } else if (explicitType.isAssignableFrom(Boolean.class) || explicitType.isAssignableFrom(Boolean.TYPE)) {
                returnObject = Boolean.parseBoolean(toString);
            } else if (explicitType.isAssignableFrom(Character.class) || explicitType.isAssignableFrom(Character.TYPE)) {
                returnObject = Character.valueOf(toString.charAt(0));
            } else if (explicitType.isAssignableFrom(Byte.class) || explicitType.isAssignableFrom(Byte.TYPE)) {
                returnObject = Byte.parseByte(toString);
            } else if (explicitType.isAssignableFrom(Short.class) || explicitType.isAssignableFrom(Short.TYPE)) {
                returnObject = Short.parseShort(toString);
            } else if (explicitType.isAssignableFrom(Float.class) || explicitType.isAssignableFrom(Float.TYPE)) {
                returnObject = Float.valueOf(Float.parseFloat(toString));
            } else if (explicitType.isAssignableFrom(Double.class) || explicitType.isAssignableFrom(Double.TYPE)) {
                returnObject = Double.parseDouble(toString);
            } else if (explicitType.isAssignableFrom(Long.class) || explicitType.isAssignableFrom(Long.TYPE)) {
                returnObject = Long.parseLong(toString);
            } else if (explicitType.isAssignableFrom(BigDecimal.class)) {
                returnObject = new BigDecimal(toString);
            } else if (explicitType.isAssignableFrom(Date.class)) {
                returnObject = new Date(toString);
            } else if (explicitType.isAssignableFrom(String.class)) {
                returnObject = toString;
            } else {
                try {
                    returnObject = explicitType.cast(object);
                }
                catch (ClassCastException e) {
                    throw new ClassCastException("Cannot convert " + object.getClass() + " to $explicitType.");
                }
            }
        } else {
            returnObject = explicitType.cast(object);
        }
        return (T)returnObject;
    }

    public static boolean canConvert(Object object, Class type) {
        try {
            SwaggerObjectConverter.convertObjectTo(object, type);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

