/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.swagger.domain;

import com.strategicgains.restexpress.plugin.swagger.domain.ApiOperationParameters;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiResponse;
import com.strategicgains.restexpress.plugin.swagger.domain.DataType;
import com.wordnik.swagger.annotations.ApiImplicitParam;
import com.wordnik.swagger.annotations.ApiImplicitParams;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponses;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.restexpress.route.Route;

public class ApiOperation
extends DataType {
    private String method;
    private String nickname = "";
    private List<ApiOperationParameters> parameters = new ArrayList<ApiOperationParameters>();
    private String summary = "";
    private String notes;
    private List<ApiResponse> responseMessages;
    private Class<?> response;

    public ApiOperation(Route route) {
        Method m = route.getAction();
        if (m.isAnnotationPresent(com.wordnik.swagger.annotations.ApiOperation.class)) {
            com.wordnik.swagger.annotations.ApiOperation ao = m.getAnnotation(com.wordnik.swagger.annotations.ApiOperation.class);
            if (ao.value() != null) {
                this.summary = ao.value();
            }
            if (ao.notes() != null) {
                this.notes = ao.notes();
            }
            if (ao.response() != null) {
                this.response = ao.response();
            }
        }
        this.method = route.getMethod().name();
        String name = route.getName();
        this.nickname = this.method + (name == null ? "" : name);
        this.nickname = this.nickname.replaceAll("[^a-zA-Z0-9_]", "");
        if (route.getUrlParameters() == null) {
            return;
        }
        for (String param : route.getUrlParameters()) {
            if (param.equals("format")) continue;
            this.addParameter(new ApiOperationParameters("path", param, "string", true));
        }
        this.determineBodyInputParameters(m);
        this.checkForSwaggerResponseAnnotations(m);
    }

    public void addParameter(ApiOperationParameters param) {
        this.parameters.add(param);
    }

    public void addResponse(ApiResponse response) {
        if (this.responseMessages == null) {
            this.responseMessages = new ArrayList<ApiResponse>();
        }
        this.responseMessages.add(response);
    }

    public void determineBodyInputParameters(Method method) {
        ApiImplicitParam aip;
        ApiOperationParameters inputParam;
        if (method.isAnnotationPresent(ApiParam.class)) {
            ApiParam ap = method.getAnnotation(ApiParam.class);
            inputParam = new ApiOperationParameters("body", ap.name(), "string", ap.required());
            if (ap.allowableValues() != null && !ap.allowableValues().equals("")) {
                inputParam.setAllowableValues(ap.allowableValues());
            }
            if (ap.value() != null && !ap.value().equals("")) {
                inputParam.setDescription(ap.value());
            }
            if (ap.defaultValue() != null && !ap.defaultValue().equals("")) {
                inputParam.setDefaultValue(ap.defaultValue());
            }
            this.addParameter(inputParam);
        }
        if (method.isAnnotationPresent(ApiImplicitParam.class)) {
            aip = method.getAnnotation(ApiImplicitParam.class);
            inputParam = new ApiOperationParameters(aip.paramType(), aip.name(), aip.dataType(), aip.required());
            if (aip.allowableValues() != null && !aip.allowableValues().equals("")) {
                inputParam.setAllowableValues(aip.allowableValues());
            }
            if (aip.value() != null && !aip.value().equals("")) {
                inputParam.setDescription(aip.value());
            }
            this.addParameter(inputParam);
        }
        if (method.isAnnotationPresent(ApiImplicitParams.class)) {
            aip = method.getAnnotation(ApiImplicitParams.class);
            for (ApiImplicitParam ip : aip.value()) {
                ApiOperationParameters inputParam2 = new ApiOperationParameters(ip.paramType(), ip.name(), ip.dataType(), ip.required());
                if (ip.allowableValues() != null && !ip.allowableValues().equals("")) {
                    inputParam2.setAllowableValues(ip.allowableValues());
                }
                if (ip.value() != null && !ip.value().equals("")) {
                    inputParam2.setDescription(ip.value());
                }
                this.addParameter(inputParam2);
            }
        }
    }

    public void checkForSwaggerResponseAnnotations(Method m) {
        if (m.isAnnotationPresent(com.wordnik.swagger.annotations.ApiResponse.class)) {
            com.wordnik.swagger.annotations.ApiResponse ar = m.getAnnotation(com.wordnik.swagger.annotations.ApiResponse.class);
            ApiResponse apiResponse = new ApiResponse(ar.code(), ar.message());
            this.addResponse(apiResponse);
        } else if (m.isAnnotationPresent(ApiResponses.class)) {
            ApiResponses ar = m.getAnnotation(ApiResponses.class);
            for (com.wordnik.swagger.annotations.ApiResponse r : ar.value()) {
                ApiResponse apiResponse = new ApiResponse(r.code(), r.message());
                this.addResponse(apiResponse);
            }
        }
    }

    public Class<?> getResponse() {
        return this.response;
    }
}

