/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.swagger.domain;

import com.strategicgains.restexpress.plugin.swagger.ModelResolver;
import com.strategicgains.restexpress.plugin.swagger.annotations.ApiModelRequest;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiDeclaration;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiModel;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiOperation;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiOperationParameters;
import com.strategicgains.restexpress.plugin.swagger.domain.ApiResources;
import com.strategicgains.restexpress.plugin.swagger.domain.DataType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.restexpress.RestExpress;
import org.restexpress.route.Route;

public class ApiDeclarations {
    private String apiVersion;
    private String swaggerVersion;
    private String basePath;
    private String resourcePath;
    private List<String> consumes;
    private List<String> produces;
    private List<ApiDeclaration> apis = new ArrayList<ApiDeclaration>();
    private transient Map<String, ApiDeclaration> apisByPath = new LinkedHashMap<String, ApiDeclaration>();
    private Map<String, ApiModel> models = new HashMap<String, ApiModel>();

    public ApiDeclarations(ApiDeclarations that) {
        this.apiVersion = that.apiVersion;
        this.swaggerVersion = that.swaggerVersion;
        this.basePath = that.basePath;
        this.resourcePath = that.resourcePath;
        this.consumes = that.consumes;
        this.produces = that.produces;
        this.apis = that.apis;
        this.apisByPath = that.apisByPath;
        this.models = that.models;
    }

    public ApiDeclarations(ApiResources api, RestExpress server, String path) {
        this.apiVersion = api.getApiVersion();
        this.swaggerVersion = api.getSwaggerVersion();
        this.basePath = this.computeBasePath(server.getBaseUrl());
        this.resourcePath = path;
    }

    private String computeBasePath(String baseUrl) {
        return baseUrl == null || baseUrl.startsWith("{") && baseUrl.endsWith("}") ? null : baseUrl;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean hasBasePath() {
        return this.basePath != null;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void addApi(ApiDeclaration api) {
        this.apis.add(api);
        this.apisByPath.put(api.getPath(), api);
    }

    public ApiDeclarations consumes(String contentType) {
        if (this.consumes == null) {
            this.consumes = new ArrayList<String>();
        }
        if (!this.consumes.contains(contentType)) {
            this.consumes.add(contentType);
        }
        return this;
    }

    public ApiDeclarations produces(String contentType) {
        if (this.produces == null) {
            this.produces = new ArrayList<String>();
        }
        if (!this.produces.contains(contentType)) {
            this.produces.add(contentType);
        }
        return this;
    }

    public ApiDeclarations addModel(ApiModel model) {
        if (!this.models.containsKey(model.getId())) {
            this.models.put(model.getId(), model);
        }
        return this;
    }

    public Map<String, ApiModel> getModels() {
        return this.models;
    }

    public ApiOperation addOperation(Route route) {
        ApiDeclaration apiDeclaration = this.apisByPath.get(route.getPattern());
        if (apiDeclaration == null) {
            apiDeclaration = new ApiDeclaration(route);
            this.addApi(apiDeclaration);
        }
        ApiOperation operation = new ApiOperation(route);
        apiDeclaration.operation(operation);
        return operation;
    }

    public void addModels(ApiOperation operation, Route route) {
        ModelResolver resolver = new ModelResolver(this.models);
        DataType returnType = null;
        returnType = operation.getResponse() != null && operation.getResponse() != Void.class ? resolver.resolve(operation.getResponse()) : resolver.resolve(route.getAction().getGenericReturnType());
        if (returnType.getRef() != null) {
            operation.setType(returnType.getRef());
        } else {
            operation.setType(returnType.getType());
            operation.setItems(returnType.getItems());
        }
        ApiModelRequest apiModelRequest = route.getAction().getAnnotation(ApiModelRequest.class);
        if (apiModelRequest != null) {
            DataType bodyType = resolver.resolve(apiModelRequest.model(), apiModelRequest.modelName());
            String type = bodyType.getRef() != null ? bodyType.getRef() : bodyType.getType();
            ApiOperationParameters bodyParam = new ApiOperationParameters("body", "body", type, apiModelRequest.required());
            if ("array".equals(bodyParam.getType())) {
                bodyParam.setItems(bodyType.getItems());
            }
            operation.addParameter(bodyParam);
        }
    }
}

