/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.swagger;

import com.strategicgains.restexpress.plugin.swagger.SwaggerController;
import io.netty.handler.codec.http.HttpMethod;
import java.util.Map;
import org.restexpress.RestExpress;
import org.restexpress.plugin.RoutePlugin;
import org.restexpress.route.RouteBuilder;

public class SwaggerPlugin
extends RoutePlugin {
    private static final String SWAGGER_VERSION = "1.2";
    private SwaggerController controller;
    private String urlPath;
    private String apiVersion;
    private String swaggerVersion = "1.2";
    private boolean defaultToHidden = false;

    public SwaggerPlugin() {
        this("/api-docs");
    }

    public SwaggerPlugin(String urlPath) {
        this.urlPath = urlPath;
    }

    public SwaggerPlugin apiVersion(String version) {
        this.apiVersion = version;
        return this;
    }

    public SwaggerPlugin swaggerVersion(String version) {
        this.swaggerVersion = version;
        return this;
    }

    public SwaggerPlugin register(RestExpress server) {
        if (this.isRegistered()) {
            return this;
        }
        super.register(server);
        this.controller = new SwaggerController(server, this.apiVersion, this.swaggerVersion, this.isDefaultToHidden());
        RouteBuilder resources = server.uri(this.urlPath, (Object)this.controller).action("readAll", HttpMethod.GET).name("swagger.resources").format("json");
        RouteBuilder apis = server.uri(this.urlPath + "/{path}", (Object)this.controller).method(new HttpMethod[]{HttpMethod.GET}).name("swagger.apis").format("json");
        for (String string : this.flags()) {
            resources.flag(string);
            apis.flag(string);
        }
        for (Map.Entry entry : this.parameters().entrySet()) {
            resources.parameter((String)entry.getKey(), entry.getValue());
            apis.parameter((String)entry.getKey(), entry.getValue());
        }
        return this;
    }

    public void bind(RestExpress server) {
        this.controller.initialize(this.urlPath, server);
    }

    public boolean isDefaultToHidden() {
        return this.defaultToHidden;
    }

    public SwaggerPlugin setDefaultToHidden(boolean defaultToHidden) {
        this.defaultToHidden = defaultToHidden;
        return this;
    }
}

