/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.restexpress.plugin.metrics;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.restexpress.Request;
import org.restexpress.Response;

public class LogOutputFactory {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private String machineName = null;

    public LogOutputFactory() {
    }

    public LogOutputFactory(String name) {
        this.machineName = name;
    }

    public StringBuilder createStringBuilder(Request request, Response response, Long duration) {
        StringBuilder builder = new StringBuilder();
        builder.append("Time=" + ((DateFormat)DATE_FORMAT.clone()).format(new Date()));
        builder.append(" RequestTime=" + duration);
        builder.append(" URL=" + request.getUrl());
        builder.append(" Method=" + request.getHttpMethod().name());
        builder.append(" Format=" + request.getFormat());
        if (request.getResolvedRoute() != null) {
            builder.append(" Resource=" + request.getResolvedRoute().getFullPattern());
        }
        if (this.machineName != null) {
            builder.append(" Machine=" + this.machineName);
        }
        builder.append(" CorrelationId=" + request.getCorrelationId());
        builder.append(" Status=" + response.getResponseStatus().code());
        if (request.getHeader("User-Agent") != null) {
            builder.append(" UserAgent=" + request.getHeader("User-Agent"));
        }
        if (request.getHeader("Referer") != null) {
            builder.append(" UrlReferer=" + request.getHeader("Referer"));
        }
        return builder;
    }

    public String create(Request request, Response response, Long duration) {
        return this.createStringBuilder(request, response, duration).toString();
    }
}

