/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator.impl;

import com.strategicgains.syntaxe.annotation.RegexValidation;
import com.strategicgains.syntaxe.util.Validations;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexValidator
extends AnnotatedFieldValidator<RegexValidation> {
    private Pattern regex;

    public RegexValidator(Field field, RegexValidation annotation) {
        super(field, annotation);
        this.regex = Pattern.compile(annotation.pattern());
    }

    @Override
    public void perform(Object instance, List<String> errors) {
        Object value = this.getValue(instance);
        String name = this.determineFieldName();
        if (!((RegexValidation)this.getAnnotation()).nullable() && value == null) {
            errors.add(name + " is required");
            return;
        }
        if (this.isCollection()) {
            this.validateCollection(name, !((RegexValidation)this.getAnnotation()).nullable(), value == null ? null : (Collection)value, errors);
        } else if (this.isArray()) {
            this.validateArray(name, !((RegexValidation)this.getAnnotation()).nullable(), value == null ? null : (Object[])value, errors);
        } else {
            this.validateRegex(name, value, ((RegexValidation)this.getAnnotation()).nullable(), this.regex, ((RegexValidation)this.getAnnotation()).message(), errors);
        }
    }

    @Override
    protected void validate(String name, Object value, List<String> errors) {
        this.validateRegex(name, value, ((RegexValidation)this.getAnnotation()).nullable(), this.regex, ((RegexValidation)this.getAnnotation()).message(), errors);
    }

    private void validateRegex(String name, Object value, boolean isNullable, Pattern regex, String message, List<String> errors) {
        Matcher matcher;
        if (value != null && !(value instanceof String)) {
            errors.add(name + " must be a string");
            return;
        }
        String stringValue = (String)value;
        if (!isNullable) {
            Validations.require(name, stringValue, errors);
        }
        if (stringValue != null && !(matcher = regex.matcher(stringValue)).matches()) {
            if (message != null && !message.trim().isEmpty()) {
                errors.add(name + " " + message);
            } else {
                errors.add(name + " does not match the regular expression pattern: " + regex.pattern());
            }
        }
    }

    protected String determineFieldName() {
        return ((RegexValidation)this.getAnnotation()).name().isEmpty() ? this.getFieldName() : ((RegexValidation)this.getAnnotation()).name();
    }
}

