/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator.impl;

import com.strategicgains.syntaxe.annotation.LongValidation;
import com.strategicgains.syntaxe.util.Validations;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class LongValidator
extends AnnotatedFieldValidator<LongValidation> {
    public LongValidator(Field field, LongValidation annotation) {
        super(field, annotation);
    }

    @Override
    public void perform(Object instance, List<String> errors) {
        String name = this.determineName();
        Object value = this.getValue(instance);
        if (value == null) {
            if (!((LongValidation)this.getAnnotation()).isNullable()) {
                Validations.require(name, null, errors);
            }
            return;
        }
        if (this.isArray()) {
            this.validateArray(name, !((LongValidation)this.getAnnotation()).isNullable(), (Object[])value, errors);
        }
        if (this.isCollection()) {
            this.validateCollection(name, !((LongValidation)this.getAnnotation()).isNullable(), (Collection)value, errors);
        } else {
            this.validate(name, value, errors);
        }
    }

    @Override
    protected void validate(String name, Object value, List<String> errors) {
        long actual;
        if (((LongValidation)this.getAnnotation()).min() != Long.MIN_VALUE) {
            actual = (Long)value;
            Validations.greaterThanOrEqual(name, actual, ((LongValidation)this.getAnnotation()).min(), errors);
        }
        if (((LongValidation)this.getAnnotation()).max() != Long.MAX_VALUE) {
            actual = (Long)value;
            Validations.lessThanOrEqual(name, actual, ((LongValidation)this.getAnnotation()).max(), errors);
        }
    }

    private String determineName() {
        return ((LongValidation)this.getAnnotation()).name().isEmpty() ? this.getFieldName() : ((LongValidation)this.getAnnotation()).name();
    }
}

