/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator.impl;

import com.strategicgains.syntaxe.annotation.IntegerValidation;
import com.strategicgains.syntaxe.util.Validations;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class IntegerValidator
extends AnnotatedFieldValidator<IntegerValidation> {
    public IntegerValidator(Field field, IntegerValidation annotation) {
        super(field, annotation);
    }

    @Override
    public void perform(Object instance, List<String> errors) {
        String name = this.determineName();
        Object value = this.getValue(instance);
        if (value == null) {
            if (!((IntegerValidation)this.getAnnotation()).isNullable()) {
                Validations.require(name, null, errors);
            }
            return;
        }
        if (this.isArray()) {
            this.validateArray(name, !((IntegerValidation)this.getAnnotation()).isNullable(), (Object[])value, errors);
        } else if (this.isCollection()) {
            this.validateCollection(name, !((IntegerValidation)this.getAnnotation()).isNullable(), (Collection)value, errors);
        } else {
            this.validate(name, value, errors);
        }
    }

    @Override
    protected void validate(String name, Object value, List<String> errors) {
        int intValue;
        if (((IntegerValidation)this.getAnnotation()).min() != Integer.MIN_VALUE) {
            intValue = (Integer)value;
            Validations.greaterThanOrEqual(name, intValue, ((IntegerValidation)this.getAnnotation()).min(), errors);
        }
        if (((IntegerValidation)this.getAnnotation()).max() != Integer.MAX_VALUE) {
            intValue = (Integer)value;
            Validations.lessThanOrEqual(name, intValue, ((IntegerValidation)this.getAnnotation()).max(), errors);
        }
    }

    private String determineName() {
        return ((IntegerValidation)this.getAnnotation()).name().isEmpty() ? this.getFieldName() : ((IntegerValidation)this.getAnnotation()).name();
    }
}

