/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator.impl;

import com.strategicgains.syntaxe.annotation.FloatValidation;
import com.strategicgains.syntaxe.util.Validations;
import com.strategicgains.syntaxe.validator.AnnotatedFieldValidator;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public class FloatValidator
extends AnnotatedFieldValidator<FloatValidation> {
    public FloatValidator(Field field, FloatValidation annotation) {
        super(field, annotation);
    }

    @Override
    public void perform(Object instance, List<String> errors) {
        String name = this.determineName();
        Object value = this.getValue(instance);
        if (value == null) {
            if (!((FloatValidation)this.getAnnotation()).isNullable()) {
                Validations.require(name, null, errors);
            }
            return;
        }
        if (this.isArray()) {
            this.validateArray(name, !((FloatValidation)this.getAnnotation()).isNullable(), (Object[])value, errors);
        } else if (this.isCollection()) {
            this.validateCollection(name, !((FloatValidation)this.getAnnotation()).isNullable(), (Collection)value, errors);
        } else {
            this.validate(name, value, errors);
        }
    }

    @Override
    protected void validate(String name, Object value, List<String> errors) {
        float floatValue;
        if (((FloatValidation)this.getAnnotation()).min() != Float.MIN_VALUE) {
            floatValue = ((Float)value).floatValue();
            Validations.greaterThanOrEqual(name, floatValue, ((FloatValidation)this.getAnnotation()).min(), errors);
        }
        if (((FloatValidation)this.getAnnotation()).max() != Float.MAX_VALUE) {
            floatValue = ((Float)value).floatValue();
            Validations.lessThanOrEqual(name, floatValue, ((FloatValidation)this.getAnnotation()).max(), errors);
        }
    }

    private String determineName() {
        return ((FloatValidation)this.getAnnotation()).name().isEmpty() ? this.getFieldName() : ((FloatValidation)this.getAnnotation()).name();
    }
}

