/*
 * Decompiled with CFR 0.152.
 */
package com.strategicgains.syntaxe.validator;

import com.strategicgains.syntaxe.validator.AbstractFieldValidator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;

public abstract class AnnotatedFieldValidator<AnnotationType extends Annotation>
extends AbstractFieldValidator {
    private AnnotationType annotation;

    public AnnotatedFieldValidator(Field field, AnnotationType annotation) {
        super(field);
        this.annotation = annotation;
    }

    protected AnnotationType getAnnotation() {
        return this.annotation;
    }

    protected void validateCollection(String name, boolean isRequired, Collection<Object> values, List<String> errors) {
        if (values == null) {
            return;
        }
        if (isRequired && values.isEmpty()) {
            errors.add(name + " is required");
        }
        int i = 0;
        for (Object value : values) {
            this.validate(name + "[" + i++ + "]", value, errors);
        }
    }

    protected void validateArray(String name, boolean isRequired, Object[] values, List<String> errors) {
        if (values == null) {
            return;
        }
        if (isRequired && values.length == 0) {
            errors.add(name + " is required");
        }
        int i = 0;
        for (Object value : values) {
            this.validate(name + "[" + i++ + "]", value, errors);
        }
    }

    protected abstract void validate(String var1, Object var2, List<String> var3);
}

